#CUI (DrTurboTax) Docker Deployments

Docker is an application build and deployment tool that packages your code with dependencies into an application container and creates isolated linux processes using software fences.  Multiple applications that rely on different versions of the same dependency can coexist on the same operating system.  

The images created during a docker build are a snapshot of the contents a container is meant to run.  Images are version controlled, retrievable and re-buildable.  


###Getting Started 

To get started using Docker locally on your Windows development machine, go to (https://docs.docker.com/toolbox/toolbox_install_windows/) and install Docker Toolbox. If you are working on a MAC, follow instructions here: (https://docs.docker.com/docker-for-mac/docker-toolbox/). This will give you everything you need for a docker build/deployment of the CUI application on your local machine.  

###Developer local install

Create a folder name cui on your local machine and clone or checkout the source code to it.

When you are ready to install, run the docker_cui_create.sh script supplying it with which environment you want to install for.  Options: dev, uat, sqa, prod
Note: only dev works at this time

  `./docker_cui_create.sh dev`

When this script has completed with no errors you should have two docker containers running, one for the cui app and one for the drturbotax db which has been loaded with the rake db:migrate db:seed commands.

To see if your containers are running, in your docker quickstart terminal type: 

   `docker ps`

You should see two entries with container names of cui_web_1 and cui_db_1 that look like this:

CONTAINER ID        IMAGE               COMMAND                  CREATED
     STATUS              PORTS                    NAMES
83bfb70702a1        cuidev              "bundle exec rails s "   20 hours ago
     Up 20 hours         0.0.0.0:3000->3000/tcp   cui_web_1
6e6d082a4c7a        postgre-cui         "/usr/lib/postgresql/"   20 hours ago
     Up 20 hours         0.0.0.0:5432->5432/tcp   cui_db_1

You can now open the CUI app in a browser with (http://localhost:3000/) if using the native Windows docker install.   If using docker toolbox you'll need to ssh to your docker machine and get the IP address it is using.  Localhost will not work since the docker machine is a separate vm with its own address.   To do this run the following commands to ssh to the machine and get its IP:

  'docker-machine ssh default'

at command prompt type: 

  'ifconfig'

You will want to use the IP address for "eth1" in the list of addresses: 

eth1      Link encap:Ethernet  HWaddr 08:00:27:09:43:7F
          inet addr:192.168.99.100  Bcast:192.168.99.255  Mask:255.255.255.0
	  inet6 addr: fe80::a00:27ff:fe09:437f/64 Scope:Link
	  UP BROADCAST RUNNING MULTICAST  MTU:1500  Metric:1
	  RX packets:1121680 errors:0 dropped:0 overruns:0 frame:0
	  TX packets:61887 errors:0 dropped:0 overruns:0 carrier:0
	  collisions:0 txqueuelen:1000
	  RX bytes:1614637170 (1.5 GiB)  TX bytes:10856493 (10.3 MiB)

In your browser use the IP in the url in place of localhost:  (http://192.168.99.100:3000)
