#!/usr/bin/env ruby
# test/stress/jmeter.rb
#
# Requires the jMeter program from Apache
# On Macs: brew install jmeter
#
# To get the graphs within the GUI you need jmeter-plugins at
#   https://jmeter-plugins.org/
# On the Mac download the plugins manager from the above website
# and put the jar file in:
#   /usr/local/Cellar/jmeter/3.1/libexec/lib/ext
#
# For other platforms figure it out and document it here.
#

# TODO: add command line parameters for host, count, loop, run, plan, gui. report

require 'awesome_print'
require 'descriptive_statistics'

require 'pathname'
require 'ruby-jmeter'
require 'csv'
require 'uri'

TEST_PLAN_FILENAME = "cpp.jmx"

MAX_REFERRALS       = ENV['TEST_STRESS_MAX_REFERRALS']      || 1000
MAX_CONSULTATIONS   = ENV['TEST_STRESS_MAX_CONSULTATIONS']  || 50

APP_URL     = ENV['TEST_STRESS_APP_URL']    || "http://52.222.56.104:4567"
SIGN_IN     = ENV['TEST_STRESS_SIGN_IN']    || "/sign_in"
USERNAME    = ENV['TEST_STRESS_USERNAME']   || "vhacc.cpptestuser@gmail.com"
PASSWORD    = ENV['TEST_STRESS_PASSWORD']   || "sms12345"

uri         = URI(APP_URL)

DOMAIN      = uri.host

COUNT       = ENV['TEST_STRESS_COUNT'].to_i    ||      40  # Number of concurrent threads (aka users)
RAMPUP      = ENV['TEST_STRESS_RAMPUP'].to_i   ||      10  # Number of seconds to take in getting all user threads running
LOOPS       = ENV['TEST_STRESS_LOOPS'].to_i    || 200_000  # Number of times to run the test
PAGES       = ENV['TEST_STRESS_PAGES'].to_i    ||     500  # Number of different referrals and consultations to visit
DURATION    = ENV['TEST_STRESS_DURATION'].to_i ||     600  # Number of seconds test should last

test_plan = test do
  cookies
  cache

  auth  url:      SIGN_IN,
        username: USERNAME,
        password: PASSWORD,
        domain:   DOMAIN

  threads   count:      COUNT,
            # loops:      LOOPS,
            rampup:     RAMPUP,
            duration:   DURATION,
            continue_forever: true do
    PAGES.times do
      r = 1 + rand(MAX_REFERRALS)
      c = 1 + rand(MAX_CONSULTATIONS)
      visit name: "referrals/id",     url: "#{APP_URL}/referrals/#{r}"
      visit name: "consultations/id", url: "#{APP_URL}/consultations/#{c}"
    end
  end

  aggregate_report
  summary_report
  generate_summary_results

  aggregate_graph
  graph_results

  # These graphs require several special plugins to jMeter.  Get them using the
  # jMeter Plugin Manager.

  latencies_over_time           name: 'CPP Response Latencies Over Time'
  active_threads                name: 'CPP Active Threads'
  response_codes_per_second     name: 'CPP Response Codes per Second'
  response_times_distribution   name: 'CPP Response Times Distribution'
  response_times_over_time      name: 'CPP Response Times Over Time'
  response_times_percentiles    name: 'CPP Response Times Percentiles'
  transactions_per_second       name: 'CPP Transactions per Second'

end # test do


# Just generate the XML test plan file
# test_plan.jmx(
#     file: TEST_PLAN_FILENAME
# )


# Generate the XML test plan file and execute the plan.
# The run command will not complete when "gui: true" is a parameter.  The run
# command launches the jMeter GUI application with the test plan.  You must manually
# press the Play button to execute the test plan.

test_plan.run(
    # path: path_to_jmeter_bin_directory,
    file:   TEST_PLAN_FILENAME,
    gui:    true  # when set to true brings up the jMeter GUI where you have to press Play to start the test
)

# When you quit the jMeter GUI application
# this script will continue.
