require 'rails_helper'

RSpec.describe "examinations/edit", :type => :view do
  before(:each) do
    @examination = assign(:examination, Examination.create!(
      :title => "MyString",
      :state => 1,
      :exam_id => 1,
      :clinician => 1
    ))
  end

  it "renders the edit examination form" do
    render

    assert_select "form[action=?][method=?]", examination_path(@examination), "post" do

      assert_select "input#examination_title[name=?]", "examination[title]"

      assert_select "input#examination_state[name=?]", "examination[state]"

      assert_select "input#examination_exam_id[name=?]", "examination[exam_id]"

      assert_select "input#examination_clinician[name=?]", "examination[clinician]"
    end
  end
end
