require 'rails_helper'

require_relative '../../../app/services/via_api.rb'
require_relative '../../../app/services/via_api/veteran.rb'

RSpec.describe 'Veteran', cpp: true do

  before do
    WebMock.enable!
    login_via_response = Rails.root.join("spec/support/via_api/login_via_response.xml").read
    mpi_lookup_response = Rails.root.join("spec/support/via_api/mpi_lookup_response.xml").read
    match_by_name_city_state_response = Rails.root.join("spec/support/via_api/match_by_name_city_state_response.xml").read
    url  = ENV['VIA_API_ENDPOINT_URL']
    stub_request(:post, url).with(:headers => {'Soapaction'=>'"loginVIA"'}).to_return(status: 200, body: login_via_response)
    stub_request(:post, url).with(:headers => {'Soapaction'=>'"mpiLookup"'}).to_return(status: 200, body: mpi_lookup_response)
    stub_request(:post, url).with(:headers => {'Soapaction'=>'"matchByNameCityStateMS"'}).to_return(status: 200, body: match_by_name_city_state_response)
  end

  after do
    WebMock.disable!
  end

  describe 'methods', cpp: true do
    it 'Performs the mpi_lookup operation' do
      @response = VIA_API::Veteran.mpi_lookup
      @response[:mpi_lookup_response][:patient_array][:fault][:message] == "Modality for MPI could not be found."
    end

    it 'Performs the match_by_name_city_state operation' do
      @response = VIA_API::Veteran.match_by_name_city_state
      @response[:match_by_name_city_state_ms_response][:tagged_patient_arrays][:arrays][:tagged_patient_array][:patients][:patient_to][:name] == "AARSVOLD,FAITH K"
    end
  end
end
