require 'rails_helper'

require_relative '../../../app/services/via_api.rb'
require_relative '../../../app/services/via_api/appointment_type.rb'

RSpec.describe 'AppointmentType', cpp: true do

  before do
    WebMock.enable!    
    login_via_response = Rails.root.join("spec/support/via_api/login_via_response.xml").read
    get_appointment_types_response = Rails.root.join("spec/support/via_api/get_appointment_types_response.xml").read
    url  = ENV['VIA_API_ENDPOINT_URL']
    stub_request(:post, url).with(:headers => {'Soapaction'=>'"loginVIA"'}).to_return(status: 200, body: login_via_response)
    stub_request(:post, url).with(:headers => {'Soapaction'=>'"getAppointmentTypes"'}).to_return(status: 200, body: get_appointment_types_response)
  end

  after do
    WebMock.disable!
  end

  describe 'methods', cpp: true do
    it 'Performs the get_appointment_type operation' do
      @response = VIA_API::AppointmentType.get
      expect(@response[:get_appointment_types_response][:appointment_types_array][:appointment_types][:appointment_types_to]).to be_an_instance_of(Array)
    end

  end
end
