require 'rails_helper'

require_relative '../../../app/services/via_api.rb'
require_relative '../../../app/services/via_api/appointment.rb'

RSpec.describe 'Appointment', cpp: true do

  before do
    WebMock.enable!
    login_via_response = Rails.root.join("spec/support/via_api/login_via_response.xml").read
    get_appointment_response = Rails.root.join("spec/support/via_api/get_appointments_response.xml").read
    make_appointment_response = Rails.root.join("spec/support/via_api/make_appointment_response.xml").read
    url  = ENV['VIA_API_ENDPOINT_URL']
    stub_request(:post, url).with(:headers => {'Soapaction'=>'"loginVIA"'}).to_return(status: 200, body: login_via_response)
    stub_request(:post, url).with(:headers => {'Soapaction'=>'"getAppointments"'}).to_return(status: 200, body: get_appointment_response)
    stub_request(:post, url).with(:headers => {'Soapaction'=>'"makeAppointment"'}).to_return(status: 200, body: make_appointment_response)
  end

  after do
    WebMock.disable!
  end

  describe 'methods', cpp: true do
    it 'Performs the get_appointment operation' do
      @response = VIA_API::Appointment.get_appointment
      @response.count == "66"
    end

    it 'Performs the make_appointment operation' do
      @response = VIA_API::Appointment.make_appointment
      @response[:make_appointment_response][:appointment_to][:appointment_type] == "REGULAR"
    end
  end
end
