require 'rails_helper'

RSpec.describe "Users", :type => :request do
  describe "sign in" do

    let(:user) { create(:examiner) }

    it "should require the user to sign in before visiting any page" do
      stub_const('ENV', ENV.to_hash.merge('DEVELOPER_TESTING' => "TRUE"))
      visit root_path
      expect(page).to have_content "Notice: You are operating in a test environment"
      expect(page).to have_content "You need to sign in before continuing."
      fill_in 'Email', with: user.email
      fill_in 'Password', with: 'Password'
      click_button 'Log in'
      expect(page).to have_content "Signed in successfully."
      expect(page).to have_content "Exam Iner"
      expect(page).to have_link "Sign out"
      expect(page).to have_content "No incomplete claims"
      click_link 'Sign out'
      expect(page).to have_content "You need to sign in before continuing."
    end
  end

  it "does not show the test environment mention in production" do
    stub_const('ENV', ENV.to_hash.merge('DEVELOPER_TESTING' => nil))

    visit root_path
    expect(page).to_not have_content "Notice: You are operating in a test environment"
  end

  describe "sign up" do
    # it "should allow a user to register" do
    #   visit "/users/sign_up"
    #   fill_in 'Email', with: 'user@example.com'
    #   fill_in 'Password', with: '12345678'
    #   fill_in 'Password confirmation', with: '12345678'
    #   fill_in 'First name', with: 'An'
    #   fill_in 'Last name', with: 'User'
    #   click_button 'Sign up'
    #
    #   expect(page).to have_content 'Welcome! You have signed up successfully.'
    #   expect(page.current_path).to eq root_path
    #
    #   user = User.find_by_email 'user@example.com'
    #   expect(user.first_name).to eq 'An'
    #   expect(user.last_name).to eq 'User'
    #   expect(user.roles).to eq []
    #   expect(user.is_under_review).to eq true
    # end

    # it "should have more generous permissions if CUI_DISABLE_UNDER_REVIEW is set" do
    #   ENV["CUI_DISABLE_UNDER_REVIEW"] = "true"
    #
    #   visit "/users/sign_up"
    #   fill_in 'Email', with: 'user@example.com'
    #   fill_in 'Password', with: '12345678'
    #   fill_in 'Password confirmation', with: '12345678'
    #   fill_in 'First name', with: 'An'
    #   fill_in 'Last name', with: 'User'
    #   click_button 'Sign up'
    #
    #   user = User.find_by_email 'user@example.com'
    #   expect(user.first_name).to eq 'An'
    #   expect(user.last_name).to eq 'User'
    #   expect(user.roles).to eq ["medical_assistant", "examiner"]
    #   expect(user.is_under_review).to eq false
    #
    #   ENV.delete "CUI_DISABLE_UNDER_REVIEW"
    # end

    it "should require last name" do
      visit "/users/sign_up"
      fill_in 'Email', with: 'user@example.com'
      fill_in 'Password', with: '12345678'
      fill_in 'Password confirmation', with: '12345678'
      fill_in 'First name', with: 'An'
      click_button 'Sign up'

      expect(page).to have_content "Last name can't be blank"
      expect(page.current_path).to eq "/users"
    end

    it "should require first name" do
      visit "/users/sign_up"
      fill_in 'Email', with: 'user@example.com'
      fill_in 'Password', with: '12345678'
      fill_in 'Password confirmation', with: '12345678'
      fill_in 'Last name', with: 'User'
      click_button 'Sign up'

      expect(page).to have_content "First name can't be blank"
      expect(page.current_path).to eq "/users"
    end

    it "should error if the passwords don't match" do
      visit "/users/sign_up"
      fill_in 'Email', with: 'user@example.com'
      fill_in 'Password', with: '12345678'
      fill_in 'Password confirmation', with: 'ohnoohno'
      fill_in 'First name', with: 'An'
      fill_in 'Last name', with: 'User'
      click_button 'Sign up'

      expect(page).to have_content "Password confirmation doesn't match"
      expect(page.current_path).to eq "/users"
    end
  end
end
