require 'rails_helper'

RSpec.describe EarDiseaseAndOtherSenseOrganEvaluationPresenter do
  before do
    schema_xml = XML::Document.file(Rails.root.join("app/xsd/ExamResponse/exchange/ExamResponse-2.0.xsd").to_s)
    @schema = XML::Schema.document(schema_xml)
    claim = create(:claim, date_of_birth: Date.new(1900))
    contention = create(:contention)
    claim.contentions << contention
    allow_any_instance_of(Evaluation).to receive(:to_pdf) { "" }

    evaluation_spec = EvaluationSpec.create(spec: File.read("app/exams/hearing-loss.yml"))
    evaluation = Evaluation.create(claim: claim, evaluation_spec: evaluation_spec, user: create(:user))
    contention.evaluations << evaluation

    evaluation.doc = File.read("spec/evaluations/hearing-loss.json")
    @doc = XML::Document.string(evaluation.to_xml)
  end
    
  # it "should generate valid XML for a hearing loss exam" do
  #   @doc.validate_schema(@schema)
  # end
  
  it "should set the left and right ear measurements" do
    expect(@doc.find("//tns:hearingLoss/tns:leftEar500").first.content).to eq "10"
    expect(@doc.find("//tns:hearingLoss/tns:leftEar1000").first.content).to eq "20"
    expect(@doc.find("//tns:hearingLoss/tns:leftEar2000").first.content).to eq "30"
    expect(@doc.find("//tns:hearingLoss/tns:leftEar3000").first.content).to eq "40"
    expect(@doc.find("//tns:hearingLoss/tns:leftEar4000").first.content).to eq "50"
    expect(@doc.find("//tns:hearingLoss/tns:rightEar500").first.content).to eq "10"
    expect(@doc.find("//tns:hearingLoss/tns:rightEar1000").first.content).to eq "20"
    expect(@doc.find("//tns:hearingLoss/tns:rightEar2000").first.content).to eq "30"
    expect(@doc.find("//tns:hearingLoss/tns:rightEar3000").first.content).to eq "40"
    expect(@doc.find("//tns:hearingLoss/tns:rightEar4000").first.content).to eq "50"
  end
  
  it "should set the left and right scores available nodes to 'Not Available'" do
    expect(@doc.find("//tns:hearingLoss/tns:leftEarScoresAvailable").first.content).to eq "Not Available"
    expect(@doc.find("//tns:hearingLoss/tns:rightEarScoresAvailable").first.content).to eq "Not Available"
  end
  
  it "should set the discrimination score fields" do
    expect(@doc.find("//tns:hearingLoss/tns:leftEarSpeechDiscrimination").first.content).to eq "45"
    expect(@doc.find("//tns:hearingLoss/tns:rightEarSpeechDiscrimination").first.content).to eq "45"
  end
end
