# == Schema Information
#
# Table name: rejections
#
#  id            :integer          not null, primary key
#  reason        :string
#  contention_id :integer
#  created_at    :datetime         not null
#  updated_at    :datetime         not null
#

RSpec.describe Rejection, type: :model do
  describe "links to contention" do
    before do
      @user = create(:user)
      @contention = create(:contention)
      @rejection = create(:rejection)
      @contention.rejections << @rejection
    end

    it "should link the contention true" do
      expect(@rejection.contention.id).to eq @contention.id
    end
  end

  it "should validate reason attribute" do
    expect {create(:rejection, reason: nil)}.to raise_exception ActiveRecord::RecordInvalid
  end
end
