# == Schema Information
#
# Table name: referral_statuses
#
#  id                  :integer          not null, primary key
#  name                :string
#  code                :string
#  referral_queue      :string
#  filterable_by_roles :string
#

require 'rails_helper'

RSpec.describe ReferralStatus, :type => :model do

	context "Associations" do
		it "should have many referrals", cpp: true do
	    referral_status = ReferralStatus.reflect_on_association(:referrals)
	    expect(referral_status.macro).to eq :has_many
	  end

	end

	context "Methods" do

		let(:user) { create(:vha_user) }
		referral_status_pending = ReferralStatus.find_by_code('PENDING')
		referral_status_scheduled = ReferralStatus.find_by_code('SCHEDULED')
		referral_status_review_pending = ReferralStatus.find_by_code('REVIEW_PENDING')

		it "should return true if current user's role status is in filterable_by_user", cpp: true do
			expect(referral_status_pending.filterable_by_user?(user)).to eq true
		end

		it "should return true if current user's role status is in add_to_referral_queue", cpp: true do
			expect(referral_status_pending.add_to_referral_queue?(user)).to eq true
		end

		it "Checks whether referral_status is from NON_VA_ADD_DOC_PHASES", cpp: true  do
			expect(referral_status_scheduled.non_vha_add_document_phase?).to eq true
			expect(referral_status_review_pending.non_vha_add_document_phase?).to eq false
		end

		it "Checks whether referral_status is from VA_REVIEW_CODE", cpp: true  do
			expect(referral_status_review_pending.vha_valid_for_approve?).to eq true
			expect(referral_status_scheduled.vha_valid_for_approve?).to eq false
		end

		it "Checks whether referral_status is from NON_VHA_STATUS_CODES", cpp: true  do
			expect(referral_status_review_pending.visible_for_non_vha?).to eq true
			expect(referral_status_scheduled.visible_for_non_vha?).to eq true
			expect(referral_status_pending.visible_for_non_vha?).to eq false
		end
	end
end