# == Schema Information
#
# Table name: referral_appointments
#
#  id               :integer          not null, primary key
#  content          :json
#  created_at       :datetime         not null
#  updated_at       :datetime         not null
#  referral_id      :integer
#  appointment_time :datetime
#  added_to_cprs_at :datetime
#  added_to_cprs_id :integer
#

require 'rails_helper'

RSpec.describe ReferralAppointment, :type => :model do

  context "Associtations" do
    it "should have one referral", cpp: true do
	    referral_appointment = ReferralAppointment.reflect_on_association(:referral)
	    expect(referral_appointment.macro).to eq :belongs_to
    end

    it "should have one added_to_cprs_user", cpp: true do
	    referral_appointment = ReferralAppointment.reflect_on_association(:added_to_cprs_user)
	    expect(referral_appointment.macro).to eq :belongs_to
    end
  end

  context "Validations" do
    it "appointment_type field should present", cpp: true do
      is_expected.to validate_presence_of(:appointment_type)
    end

    it "appointment_time field should present", cpp: true do
      is_expected.to validate_presence_of(:appointment_time)
    end
  end

  context "Methods" do
	  let(:user) {create(:user)}
	  let!(:referral_appointment) {create(:referral_appointment, added_to_cprs_id: user.id)}
	  let!(:referral_appointment1) {create(:referral_appointment, added_to_cprs_at: nil)}

    it "responds to added_to_cprs?" do
      expect(referral_appointment.added_to_cprs?).to eq true
      expect(referral_appointment1.added_to_cprs?).to eq false
    end

    it "should return the added_to_cprs_username" do
      expect(referral_appointment.added_to_cprs_username).to eq user.name
      expect(referral_appointment1.added_to_cprs_username).to eq nil
    end

  end
end
