# == Schema Information
#
# Table name: facilities
#
#  id      :integer          not null, primary key
#  name    :string
#  content :json
#  visn_id :integer
#

require 'rails_helper'

RSpec.describe Facility, :type => :model do

  before do
  	@facility = create(:facility)
  end

  context "Associtations" do
    it "should have many providers", cpp: true do
  	  facility = Facility.reflect_on_association(:providers)
  	  expect(facility.macro).to eq :has_many
    end

    it "should have one visn", cpp: true do
  	  facility = Facility.reflect_on_association(:visn)
  	  expect(facility.macro).to eq :belongs_to
    end
  end

  context "Methods" do
    it "should return the value of visn region prepended name", cpp: true do
  	  result_string = @facility.visn_id.to_s + ": " + @facility.name
  	  expect(@facility.visn_region_prepended_name).to eq result_string
  	end
  end

end
