# == Schema Information
#
# Table name: diagnosis_codes
#
#  id           :integer          not null, primary key
#  version_code :string           not null
#  description  :string           not null
#  deleted_at   :datetime
#

require 'rails_helper'

RSpec.describe DiagnosisCode, :type => :model do

  describe "ParanoidModelTest", cpp: true do
    it_behaves_like 'a Paranoid model'
  end

  context "methods" do
    before :context do
      @diagnosis_code = create(:diagnosis_code)
      @version_code = @diagnosis_code.version_code
    end

    it "should print the version of the diagnosis code", cpp: true do
      expect(@diagnosis_code.version.length).to eq 2
    end

    it "should print the chapter of the diagnosis code", cpp: true do
      expect(@diagnosis_code.chapter.length).to eq 3
    end

    it "should print the code of the diagnosis code", cpp: true do
      expect(@diagnosis_code.code.length).to eq 6
    end

    it "should return a string of invalid codes in a string separated by comma", cpp: true do
      expect(DiagnosisCode.validate_codes("#{@version_code}, 1234string")).to eq "1234string".upcase
    end
  end
end
