# == Schema Information
#
# Table name: veterans
#
#  id                          :integer          not null, primary key
#  ssn                         :string(10)       not null
#  first_name                  :string
#  middle_name                 :string
#  last_name                   :string
#  other_health_insurance_name :string
#  content                     :json
#  created_at                  :datetime         not null
#  updated_at                  :datetime         not null
#  other_health_insurance_id   :integer
#

FactoryGirl.define do

  get_content = -> (n) do
    fourdigit = (n+1234) % 10000
    adjusted_date = (Date.new(1953, 3, 1) + n.days).strftime('%m/%d/%Y')
    {
      veteran_number: n,
      gender: "M",
      date_of_birth: adjusted_date,
      address: ["#{fourdigit} Any Street Blvd.", "P.O. Box #{fourdigit}"],
      city: "Columbia",
      state: "MD",
      zip: "21046",
      phone: "240-555-#{fourdigit}"
   }
  end

  factory :veteran do
    sequence(:ssn)         {|n| (100_000_000 + n).to_s }
    sequence(:first_name)  {|n| "John#{n}" }
    sequence(:middle_name) {|n| "Doe#{n}" }
    sequence(:last_name)   {|n| "Testuser#{n}" }
    sequence(:other_health_insurance_name) {|n| "Insurance Provider ##{n}" }
    sequence(:content)     {|n| get_content.call(n) }
    sequence(:created_at)  {|n| "2017-0#{n}-01 00:00:00"}
    association :other_health_insurance, factory: [:other_health_insurance, :no]
  end

end
