# == Schema Information
#
# Table name: referral_documents
#
#  id                        :integer          not null, primary key
#  referral_document_type_id :integer
#  uploader_id               :integer
#  approver_id               :integer
#  approved_at               :datetime
#  content                   :json
#  created_at                :datetime         not null
#  updated_at                :datetime         not null
#  referral_id               :integer
#

# Read about factories at https://github.com/thoughtbot/factory_girl

FactoryGirl.define do

  get_content = -> (n) do
    {
      document_name: "doc#{n}.jpg"
    }
  end

  # Default referral appointment: use default (first) referral, a default
  # appointment time that should not trigger special conditions such as needs_reminder,
  # and with "Added to CPRS" unchecked.
  factory :referral_document do
    referral               { Referral.first || association(:referral) }
    referral_document_type { ReferralDocumentType.first }
    uploader_id            { create(:community_provider).id }
    sequence(:content)     {|n| get_content.call(n) }
  end

  factory :approved_referral_document, class: ReferralDocument do
    referral               { Referral.first || association(:referral) }
    referral_document_type { ReferralDocumentType.first }
    uploader_id            { create(:community_provider).id }
    sequence(:content)     {|n| get_content.call(n) }
    approver_id            { create(:vha_user).id }
    approved_at            { 1.day.ago }
  end

end
