# == Schema Information
#
# Table name: evaluations
#
#  id                            :integer          not null, primary key
#  evaluation_spec_id            :integer
#  doc                           :json
#  created_at                    :datetime
#  updated_at                    :datetime
#  claim_id                      :integer
#  completed_at                  :datetime
#  primary_evaluation_id         :integer
#  guid                          :string
#  reviewed_at                   :datetime
#  vha_user_vista_access_code    :string
#  vha_user_vista_verify_code    :string
#  vha_user_electronic_signature :string
#  user_id                       :integer
#  assigner_id                   :integer
#  examination_id                :integer
#

# Read about factories at https://github.com/thoughtbot/factory_girl

FactoryGirl.define do
  factory :evaluation do
    association :assigner, factory: :user
    association :user
    association :evaluation_spec
    association :claim
    doc "{\"form\":{\"title\":\"Diabetes mellitus evaluation\",\"version\":\"1.0\",\"id\":\"01234567890abcdefgh\",\"fieldsets\":[[{\"name\":\"hasDiabetes\",\"type\":\"yes_no\",\"label\":\"bananarama\",\"prompt\":null,\"required\":true,\"options\":null,\"conditional_on\":null,\"validations\":null}]]}}"
  end

  factory :diabetes_doc, class: Evaluation do
    doc <<-DOC
{
  "form": {
    "title": "Diabetes milletues evaluation",
    "id": "50eafff8e88cd672c15e91bd5075cf96e464b037",
    "version": "1",
    "fieldsets": [
      {
        "fieldset": [
          {
            "field": {
              "name": "hasDiabetes",
              "fieldType": "yes_no",
              "label": "Does the veteran currently have diabetes mellitus?",
              "prompt": null,
              "isRequired": true,
              "options": null,
              "conditionalOn": null,
              "validations": null,
              "value": "true"
            }
          },
          {
            "field": {
              "name": "checkboxThatShouldNotShow",
              "fieldType": "checkbox",
              "label": "This checkbox should NOT show up.",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "hasDiabetes",
              "validations": null
            }
          },
          {
            "field": {
              "name": "checkboxThatShouldShow",
              "fieldType": "checkbox",
              "label": "This checkbox SHOULD show up.",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "hasDiabetes",
              "validations": null,
              "value": false
            }
          },
          {
            "field": {
              "name": "fastingPlasmaGlucoseTest",
              "fieldType": "checkbox",
              "label": "Fasting plasma glucose test (<abbr>FPG</abbr>) of > 126 MG/DL on two (2) or more occasions?",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "hasDiabetes",
              "validations": null,
              "value": "1"
            }
          },
          {
            "field": {
              "name": "fastingPlasmaGlucoseOccurence1",
              "fieldType": "partialdate",
              "label": "Fasting Date 2",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "fastingPlasmaGlucoseTest",
              "validations": null,
              "value": "---\\nday: '1'\\nmonth: '1'\\nyear: '2014'\\nunknown: 'on'\\nestimate: \\n"
            }
          },
          {
            "field": {
              "name": "fastingPlasmaGlucoseOccurence2",
              "fieldType": "partialdate",
              "label": "Fasting Date 1",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "fastingPlasmaGlucoseTest",
              "validations": null,
              "value": "---\\nday: '2'\\nmonth: '1'\\nyear: '2014'\\nunknown: \\nestimate: 'on'\\n"
            }
          },
          {
            "field": {
              "name": "a1cPercent",
              "fieldType": "checkbox",
              "label": "A1C of 6.5% or greater on two (2) or more occasions?",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "hasDiabetes",
              "validations": null,
              "value": "0"
            }
          },
          {
            "field": {
              "name": "visibleCheckbox",
              "fieldType": "checkbox",
              "label": "Visible Checkbox",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "!a1cPercent",
              "validations": null,
              "value": "1"
            }
          },
          {
            "field": {
              "name": "hiddenCheckbox",
              "fieldType": "checkbox",
              "label": "Hidden Checkbox",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "a1cPercent",
              "validations": null,
              "value": "false"
            }
          },
          {
            "field": {
              "name": "a1cPercentOccurence1",
              "fieldType": "date",
              "label": "Date",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "a1cPercent",
              "validations": null,
              "value": "01/01/2014"
            }
          },
          {
            "field": {
              "name": "a1cPercentOccurence2",
              "fieldType": "date",
              "label": "Date",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "a1cPercent",
              "validations": null,
              "value": "01/02/2014"
            }
          },
          {
            "field": {
              "name": "twoHourPlasma",
              "fieldType": "checkbox",
              "label": "Two (2) hour plasma glucose of > 200 mg/dl on glucose tolerance test?",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "hasDiabetes",
              "validations": null,
              "value": "0"
            }
          },
          {
            "field": {
              "name": "twoHourPlasmaOccurence",
              "fieldType": "date",
              "label": "Date",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "twoHourPlasma",
              "validations": null,
              "value": ""
            }
          },
          {
            "field": {
              "name": "randomPlasmaGlucose",
              "fieldType": "checkbox",
              "label": "Random plasma glucose of 200 mg/DL with classic symptoms of hyperglycemia",
              "prompt": null,
              "isRequired": null,
              "options": null,
              "conditionalOn": "hasDiabetes",
              "validations": null
            }
          },
          {
            "field": {
              "name": "randomPlasmaGlucoseOccurence",
              "fieldType": "date",
              "label": "Date",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "randomPlasmaGlucose",
              "validations": null,
              "value": ""
            }
          },
          {
            "field": {
              "name": "otherTest",
              "fieldType": "checkbox",
              "label": "Other (please explain)",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "hasDiabetes",
              "validations": null,
              "value": "0"
            }
          },
          {
            "field": {
              "name": "otherTestExplanation",
              "fieldType": "text",
              "label": "Explanation",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "otherTest",
              "validations": null,
              "value": ""
            }
          },
          {
            "field": {
              "name": "isManagedByDiet",
              "fieldType": "yes_no",
              "label": "Is the veteran's diabetes managed by diet?",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "hasDiabetes",
              "validations": null,
              "value": "true"
            }
          },
          {
            "field": {
              "name": "requiresOralHypoglycemicAgent",
              "fieldType": "yes_no",
              "label": "Does the veteran's diabetes mellitus require an oral hypoglycemic agent?",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "hasDiabetes",
              "validations": null,
              "value": "true"
            }
          },
          {
            "field": {
              "name": "requiresInsulin",
              "fieldType": "yes_no",
              "label": "Does the veteran's diabetes mellitus require insulin?",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "hasDiabetes",
              "validations": null,
              "value": "true"
            }
          },
          {
            "field": {
              "name": "moreThanOneDailyInjection",
              "fieldType": "yes_no",
              "label": "More than one injection a day?",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "requiresInsulin",
              "validations": null,
              "value": "true"
            }
          },
          {
            "field": {
              "name": "requiresActivityRegulation",
              "fieldType": "yes_no",
              "label": "Does the veteran's diabetes mellitus require regulation of activities?",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "hasDiabetes",
              "validations": null,
              "value": "true"
            }
          },
          {
            "field": {
              "name": "includesStrenuousActivities",
              "fieldType": "yes_no",
              "label": "Does this regulation include avoidance of strenuous occupational and recreational",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "requiresActivityRegulation",
              "validations": null,
              "value": "true"
            }
          },
          {
            "field": {
              "name": "regulationExplanation",
              "fieldType": "text",
              "label": "Please explain how you determined whether the veteran requires regulation:",
              "prompt": null,
              "isRequired": false,
              "options": null,
              "conditionalOn": "requiresActivityRegulation",
              "validations": null,
              "value": "I asked him"
            }
          },
          {
            "field":{
              "name":"selectConditional",
              "fieldType":"select",
              "label":"Select something, or not",
              "isRequred":false,
              "conditionalOn": "requiresActivityRegulation",
              "options":[
                {"name":"Valid","value":"valid_option"},
                {"name":"Needs More","value":"needs_more_info"}
              ]
            }
          },
          {
            "field":{
              "name":"conditionalBox",
              "fieldType":"text",
              "label":"Should be visibile if selectConditional",
              "conditionalOn":{
                "textEquals":{
                  "field":"selectConditional",
                  "values":"needs_more_info"
                }
              }
            }
          }
        ]
      }
    ]
  }
}
    DOC
  end

  factory :tmj_eval, class: Evaluation do
    doc JSON.parse(File.read(Rails.root.join("spec/factories/evaluation_samples/dental.json")))
  end
end
