# == Schema Information
#
# Table name: evaluation_specs
#
#  id                       :integer          not null, primary key
#  title                    :text
#  version                  :text
#  spec                     :text
#  created_at               :datetime
#  updated_at               :datetime
#  body_system              :string
#  evaluation_builder_title :string
#  dependent                :string
#  spec_id                  :string
#  active                   :boolean          default(TRUE)
#

# Read about factories at https://github.com/thoughtbot/factory_girl

def suggested_exam_spec(spec_id, title)
  <<-SPEC
form:
  title: "#{title}"
  id: #{spec_id}
  version: "1.0"
  suggestedExams: [Alpha, Beta, Gamma]
  fieldsets:
    - fieldset:
      - field:
          name: "yesno"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: true
  SPEC
end

FactoryGirl.define do
  factory :evaluation_spec do
    title "Simple Yes/No Evaluation"
    version "1.0"
    sequence(:spec) do |spec_id|
      <<-SPEC
form:
  title: "Simple Yes/No Evaluation"
  id: #{spec_id}
  keywords: "Testing Keywords"
  version: "1.0"
  fieldsets:
    - fieldset:
      - field:
          name: "yesno"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: true
      SPEC
    end
  end

  factory :suggested_exam_spec, class: EvaluationSpec do
    title "Evaluation with Suggested Exams"
    version "1.0"
    sequence(:spec) do |spec_id|
      suggested_exam_spec(spec_id, "Suggested Exam Title")
    end
  end

  factory :hearing_loss_evaluation_spec, class: EvaluationSpec do
    title "Hearing Loss"
    version "1.0"
    spec <<-SPEC
form:
  title: "Hearing Loss"
  id: b6ce6731170225cb2152e185ba983947a94659f8
  keywords: "Testing Keywords"
  version: "1.0"
  fieldsets:
    - fieldset:
      - field:
          name: "yesno"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: true
    SPEC
  end

  factory :elbow_and_forearm_evaluation_spec, class: EvaluationSpec do
    title "Elbow and Forearm Evaluation"
    version "1.0"
    spec <<-SPEC
form:
  title: "Elbow and Forearm Evaluation"
  id: 41292d9962c46688b5aa8013aa85d7d8564de0e5
  keywords: "Testing Keywords"
  version: "1.0"
  fieldsets:
    - fieldset:
      - field:
          name: "yesno"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: true
    SPEC
  end

  factory :invalid_spec, class: EvaluationSpec do
    title "Simple Yes/No Evaluation"
    version "1.0"
    spec <<-SPEC
form:
  title: "Simple Yes/No Evaluation"
  id: 9c55e6e70808bacd27a1456393b82f6239a36942
  fieldsets:
    - fieldset:
      - field:
          name: "yesno"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: true
SPEC
    end

  factory :short_spec01, class: EvaluationSpec do
    title "Short Spec01"
    version "1.0.0"
    spec <<-SPEC
form:
  title: "Short Spec01"
  id: 4e2f2e14ad7d1ec57c4652d8114d7a08266d0e7f
  version: "1.0.0"
  fieldsets:
    - fieldset:
      - field:
          name: "yesno"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: true
SPEC
    end

  factory :short_spec02, class: EvaluationSpec do
    title "Short Spec02"
    version "1.0.0"
    spec <<-SPEC
form:
  title: "Short Spec02"
  id: accb54556d1e6d624f103ccf6c00f9aca95ffa4b
  version: "1.0.0"
  fieldsets:
    - fieldset:
      - field:
          name: "yesno"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: true
SPEC
    end

  factory :short_spec03, class: EvaluationSpec do
    title "Short Spec03"
    version "1.0.0"
    spec <<-SPEC
form:
  title: "Short Spec03"
  id: 323023f2467edce6df8e9d011fc7d089a60d9197
  version: "1.0.0"
  fieldsets:
    - fieldset:
      - field:
          name: "yesno"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: true
SPEC
    end

  factory :no_id_short_spec, class: EvaluationSpec do
    title "No ID Short Spec"
    version "1.0.0"
    spec <<-SPEC
form:
  title: "Short Spec03"
  id: "" 
  version: "1.0.0"
  fieldsets:
    - fieldset:
      - field:
          name: "yesno"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: true
SPEC
    end

  factory :conditional_spec, class: EvaluationSpec do
      title "Conditional Evaluation"
      version "1.0"
      spec <<-SPEC
form:
  title: "Conditional test"
  id: 156fdff5cab7885f251bfd8881ee9415ea971e53
  version: "1"
  fieldsets:
    - fieldset:
      - field:
          name: "first"
          fieldType: "yes_no"
          label: "First"
          isRequired: true
      - field:
          name: "second"
          fieldType: "yes_no"
          label: "Second"
          isRequired: false
          conditionalOn: "first"
      - field:
          name: "third"
          fieldType: "yes_no"
          label: "Third"
          conditionalOn: "second"
      - field:
          name: "third_textarea"
          fieldType: "text"
          label: "Third Textarea"
          conditionalOn: "second"
      - field:
          name: "markdown_text"
          fieldType: "markdown"
          label: "None"
          value: "Some markdown text should only appear when Yes is clicked."
          conditionalOn: "first"
SPEC
      end

    
  factory :sample_spec, class: EvaluationSpec do
    title "Sample Form"
    version "1.0"
    spec <<-SPEC
form:
  title: "Simple sample form"
  id: f6db3cdee9369ab72df7fc5034e1149df9eff94e
  keyword: "blood glucose"
  version: "1.0"
  bodySystem: "Sample"
  evaluationBuilder: "America"
  fieldsets:
    - fieldset:
      - field:
          name: "hasDiabetes"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: false
      - field:
          name: "sampleCheckbox"
          fieldType: "checkbox"
          label: "Would you like to check me?"
          isRequired: false
          conditionalOn: "hasDiabetes"
      - field:
          name: "sampleDate"
          fieldType: "date"
          label: "Pick any date"
          isRequired: true
      - field:
          name: "sampleTextarea"
          fieldType: "text"
          label: "Enter some text"
          isRequired: true
          disable: true
      - field:
          name: "sampleString"
          fieldType: "string"
          label: "This is a string"
          isRequired: true
          disable: true
      - field:
          name: "sampleRadio"
          fieldType: "radio"
          label: "Please select one of the following options"
          isRequired: false
          options:
            - name: "First"
              value: "1"
            - name: "Second"
              value: "2"
            - name: "Third"
              value: "3"
      - field:
          name: "sampleSelect"
          fieldType: "select"
          label: "Please select one of the following options"
          isRequired: false
          options:
            - name: "First"
              value: "1"
            - name: "Second"
              value: "2"
            - name: "Third"
              value: "3"
    SPEC
  end

  factory :disabled_spec, class: EvaluationSpec do
    title "Sample Form With All Fields Disabled"
    version "1.0"
    spec <<-SPEC
form:
  title: "Simple sample form"
  id: 45dd2d4d5ebd220ae635ebf0f0e57c4d70379da5
  version: "1.0"
  fieldsets:
    - fieldset:
      - field:
          name: "sampleYesNo"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: false
          disable: true
      - field:
          name: "sampleCheckbox"
          fieldType: "checkbox"
          label: "Would you like to check me?"
          isRequired: true
          disable: true
      - field:
          name: "sampleDate"
          fieldType: "date"
          label: "Pick any date"
          isRequired: true
          disable: true
      - field:
          name: "sampleTextarea"
          fieldType: "text"
          label: "Enter some text"
          isRequired: true
          disable: true
      - field:
          name: "sampleString"
          fieldType: "string"
          label: "This is a string"
          isRequired: true
          disable: true
      - field:
          name: "sampleRadio"
          fieldType: "radio"
          label: "Please select one of the following options"
          isRequired: false
          options:
            - name: "First"
              value: "1"
            - name: "Second"
              value: "2"
            - name: "Third"
              value: "3"
          disable: true
      - field:
          name: "sampleSelect"
          fieldType: "select"
          label: "Please select one of the following options"
          isRequired: false
          options:
            - name: "First"
              value: "1"
            - name: "Second"
              value: "2"
            - name: "Third"
              value: "3"
          disable: true
      - field:
          name: "samplePartialDate"
          fieldType: "partialdate"
          label: "Enter a date"
          isRequired: false
          disable: true
    SPEC
  end

  factory :diabetes_spec, class: EvaluationSpec do
    title "Diabetes Mellitus Evaluation"
    version "1.0"
    spec <<-SPEC
form:
  title: "Diabetes milletues evaluation"
  id: 84b50fd99fdb6a873d6fdfc678745f1ca36bc18c
  version: "1"
  bodySystem: "Endocrine"
  fieldsets:
    - fieldset:
      - field:
          name: "hasDiabetes"
          fieldType: "yes_no"
          label: "Does the veteran currently have diabetes mellitus?"
          isRequired: true
      - field:
          name: "fastingPlasmaGlucoseTest"
          fieldType: "checkbox"
          label: "Fasting plasma glucose test (<abbr>FPG</abbr>) of > 126 MG/DL on two (2) or more occasions?"
          isRequired: false
          conditionalOn: "hasDiabetes"
      - field:
          name: "fastingPlasmaGlucoseOccurence1"
          fieldType: "partialdate"
          label: "Date"
          isRequired: false
          conditionalOn: "fastingPlasmaGlucoseTest"
          validations:
            - requiredIf: "fastingPlasmaGlucoseTest"
      - field:
          name: "fastingPlasmaGlucoseOccurence2"
          fieldType: "partialdate"
          label: "Date"
          isRequired: false
          conditionalOn: "fastingPlasmaGlucoseTest"
          validations:
            - requiredIf: "fastingPlasmaGlucoseTest"
      - field:
          name: "a1cPercent"
          fieldType: "checkbox"
          label: "A1C of 6.5% or greater on two (2) or more occasions?"
          isRequired: false
          conditionalOn: "hasDiabetes"
      - field:
          name: "a1cPercentOccurence1"
          fieldType: "date"
          label: "Date"
          isRequired: false
          conditionalOn: "a1cPercent"
      - field:
          name: "a1cPercentOccurence2"
          fieldType: "date"
          label: "Date"
          isRequired: false
          conditionalOn: "a1cPercent"
      - field:
          name: "twoHourPlasma"
          fieldType: "checkbox"
          label: "Two (2) hour plasma glucose of > 200 mg/dl on glucose tolerance test?"
          isRequired: false
          conditionalOn: "hasDiabetes"
      - field:
          name: "twoHourPlasmaOccurence"
          fieldType: "date"
          label: "Date"
          isRequired: false
          conditionalOn: "twoHourPlasma"
      - field:
          name: "randomPlasmaGlucose"
          fieldType: "checkbox"
          label: "Random plasma glucose of 200 mg/DL with classic symptoms of hyperglycemia"
          isRequied: false
          conditionalOn: "hasDiabetes"
      - field:
          name: "randomPlasmaGlucoseOccurence"
          fieldType: "date"
          label: "Date"
          isRequired: false
          conditionalOn: "randomPlasmaGlucose"
      - field:
          name: "otherTest"
          fieldType: "checkbox"
          label: "Other (please explain)"
          isRequired: false
          conditionalOn: "hasDiabetes"
      - field:
          name: "otherTestExplanation"
          fieldType: "text"
          label: "Explanation"
          isRequired: false
          conditionalOn: "otherTest"
      - field:
          name: "isManagedByDiet"
          fieldType: "yes_no"
          label: "Is the veteran's diabetes managed by diet?"
          isRequired: false
          conditionalOn: "hasDiabetes"
          disabled: true
      - field:
          name: "requiresOralHypoglycemicAgent"
          fieldType: "yes_no"
          label: "Does the veteran's diabetes mellitus require an oral hypoglycemic agent?"
          isRequired: false
          conditionalOn: "hasDiabetes"
      - field:
          name: "requiresInsulin"
          fieldType: "yes_no"
          label: "Does the veteran's diabetes mellitus require insulin?"
          isRequired: false
          conditionalOn: "hasDiabetes"
      - field:
          name: "moreThanOneDailyInjection"
          fieldType: "yes_no"
          label: "More than one injection a day?"
          isRequired: false
          conditionalOn: "requiresInsulin"
      - field:
          name: "requiresActivityRegulation"
          fieldType: "yes_no"
          label: "Does the veteran's diabetes mellitus require regulation of activities?"
          isRequired: false
          conditionalOn: "hasDiabetes"
      - field:
          name: "includesStrenuousActivities"
          fieldType: "yes_no"
          label: "Does this regulation include avoidance of strenuous occupational and recreational"
          isRequired: false
          conditionalOn: "requiresActivityRegulation"
      - field:
          name: "regulationExplanation"
          fieldType: "text"
          label: "Please explain how you determined whether the veteran requires regulation:"
          isRequired: false
          conditionalOn: "requiresActivityRegulation"
      - field:
          name: "testRadio"
          fieldType: "radio"
          label: "Please select one of the following options"
          isRequired: false
          options:
            - name: "First"
              value: "1"
            - name: "Second"
              value: "2"
            - name: "Third"
              value: "3"
      - field:
          name: "testSelect"
          fieldType: "select"
          label: "Please select one of the following options"
          isRequired: false
          options:
            - name: "First"
              value: "1"
            - name: "Second"
              value: "2"
            - name: "Third"
              value: "3"
      - field:
          name: "testNumber"
          fieldType: "number"
          label: "Test Number"
          isRequired: true
      - field:
          name: "selectConditional"
          fieldType: "select"
          label: "Select something, or not"
          isRequred: false
          options:
            - name: "Valid"
              value: "valid_option"
            - name: "Needs More"
              value: "needs_more_info"
      - field:
          name: "conditionalBox"
          fieldType: "text"
          label: "Should be visibile if selectConditional"
          conditionalOn:
            textEquals:
              field: selectConditional
              values: needs_more_info
    SPEC
  end

  factory :tmj_spec, class: EvaluationSpec do
    title "TMJ Evaluation"
    version "1.0"
    spec File.read(Rails.root.join("app/exams/temporomandibular-joint-tmj.yml"))
  end

  factory :dependent_spec, class: EvaluationSpec do
    title "Dependent On Endocrine Spec"
    version "1.0"
    spec <<-SPEC
form:
  title: "Dependent on Endocrine Spec"
  id: ea1f48d960c76fa47a217764b48388703d1f850b
  keywords: "Testing Keywords"
  version: "1.0"
  dependent: "endocrine"
  fieldsets:
    - fieldset:
      - field:
          name: "yesno"
          fieldType: "yes_no"
          label: "bananarama"
          isRequired: true
    SPEC
  end
end
