require 'rails_helper'

RSpec.describe "Exams" do
  it "there should be no exams with duplicate ids" do
    ids = Dir[Rails.root.join("app/exams/*.yml")].map do |f|
      YAML.load(File.read(f))["form"]["id"]
    end
    expect(ids.uniq.length).to eq ids.length
  end

  it "each exam should be valid FML" do
    Dir[Rails.root.join("app/exams/*.yml")].map do |f|
      FML::Form.new(File.read(f))
    end
  end
end
