require 'rails_helper'

# This spec was generated by rspec-rails when you ran the scaffold generator.
# It demonstrates how one might use RSpec to specify the controller code that
# was generated by Rails when you ran the scaffold generator.
#
# It assumes that the implementation code is generated by the rails scaffold
# generator.  If you are using any extension libraries to generate different
# controller code, this generated spec may or may not pass.
#
# It only uses APIs available in rails and/or rspec-rails.  There are a number
# of tools you can use to make these specs even more expressive, but we're
# sticking to rails and rspec-rails APIs to keep things simple and stable.
#
# Compared to earlier versions of this generator, there is very limited use of
# stubs and message expectations in this spec.  Stubs are only used when there
# is no simpler way to get a handle on the object needed for the example.
# Message expectations are only used when there is no simpler way to specify
# that an instance is receiving a specific message.

RSpec.describe SupportRequestsController, :type => :controller do

  # This should return the minimal set of attributes required to create a valid
  # SupportRequest. As you add validations to SupportRequest, be sure to
  # adjust the attributes here as well.
  let(:valid_attributes) {
    skip("Add a hash of attributes valid for your model")
  }

  let(:invalid_attributes) {
    skip("Add a hash of attributes invalid for your model")
  }

  # This should return the minimal set of values that should be in the session
  # in order to pass any filters (e.g. authentication) defined in
  # SupportRequestsController. Be sure to keep this updated too.
  let(:valid_session) { {} }

  describe "GET index" do
    it "assigns all support_requests as @support_requests" do
      support_request = SupportRequest.create! valid_attributes
      get :index, {}, valid_session
      expect(assigns(:support_requests)).to eq([support_request])
    end
  end

  describe "GET show" do
    it "assigns the requested support_request as @support_request" do
      support_request = SupportRequest.create! valid_attributes
      get :show, {:id => support_request.to_param}, valid_session
      expect(assigns(:support_request)).to eq(support_request)
    end
  end

  describe "GET new" do
    it "assigns a new support_request as @support_request" do
      get :new, {}, valid_session
      expect(assigns(:support_request)).to be_a_new(SupportRequest)
    end
  end

  describe "GET edit" do
    it "assigns the requested support_request as @support_request" do
      support_request = SupportRequest.create! valid_attributes
      get :edit, {:id => support_request.to_param}, valid_session
      expect(assigns(:support_request)).to eq(support_request)
    end
  end

  describe "POST create" do
    describe "with valid params" do
      it "creates a new SupportRequest" do
        expect {
          post :create, {:support_request => valid_attributes}, valid_session
        }.to change(SupportRequest, :count).by(1)
      end

      it "assigns a newly created support_request as @support_request" do
        post :create, {:support_request => valid_attributes}, valid_session
        expect(assigns(:support_request)).to be_a(SupportRequest)
        expect(assigns(:support_request)).to be_persisted
      end

      it "redirects to the created support_request" do
        post :create, {:support_request => valid_attributes}, valid_session
        expect(response).to redirect_to(SupportRequest.last)
      end
    end

    describe "with invalid params" do
      it "assigns a newly created but unsaved support_request as @support_request" do
        post :create, {:support_request => invalid_attributes}, valid_session
        expect(assigns(:support_request)).to be_a_new(SupportRequest)
      end

      it "re-renders the 'new' template" do
        post :create, {:support_request => invalid_attributes}, valid_session
        expect(response).to render_template("new")
      end
    end
  end

  describe "PUT update" do
    describe "with valid params" do
      let(:new_attributes) {
        skip("Add a hash of attributes valid for your model")
      }

      it "updates the requested support_request" do
        support_request = SupportRequest.create! valid_attributes
        put :update, {:id => support_request.to_param, :support_request => new_attributes}, valid_session
        support_request.reload
        skip("Add assertions for updated state")
      end

      it "assigns the requested support_request as @support_request" do
        support_request = SupportRequest.create! valid_attributes
        put :update, {:id => support_request.to_param, :support_request => valid_attributes}, valid_session
        expect(assigns(:support_request)).to eq(support_request)
      end

      it "redirects to the support_request" do
        support_request = SupportRequest.create! valid_attributes
        put :update, {:id => support_request.to_param, :support_request => valid_attributes}, valid_session
        expect(response).to redirect_to(support_request)
      end
    end

    describe "with invalid params" do
      it "assigns the support_request as @support_request" do
        support_request = SupportRequest.create! valid_attributes
        put :update, {:id => support_request.to_param, :support_request => invalid_attributes}, valid_session
        expect(assigns(:support_request)).to eq(support_request)
      end

      it "re-renders the 'edit' template" do
        support_request = SupportRequest.create! valid_attributes
        put :update, {:id => support_request.to_param, :support_request => invalid_attributes}, valid_session
        expect(response).to render_template("edit")
      end
    end
  end

  describe "DELETE destroy" do
    it "destroys the requested support_request" do
      support_request = SupportRequest.create! valid_attributes
      expect {
        delete :destroy, {:id => support_request.to_param}, valid_session
      }.to change(SupportRequest, :count).by(-1)
    end

    it "redirects to the support_requests list" do
      support_request = SupportRequest.create! valid_attributes
      delete :destroy, {:id => support_request.to_param}, valid_session
      expect(response).to redirect_to(support_requests_url)
    end
  end

end
