namespace :exam_requests do

  desc "Copy existing exam_request data to claims;"
  task copy_existing_data_to_claims: :environment do
    ExamRequest.where.not(claim_id: nil).each do |exam_request|
      begin
        if claim = Claim.find(exam_request.claim_id)
          if claim.exam_request_data.blank?
            if claim.update_attributes!(exam_request_data:  Hash.from_xml(exam_request.xml))
            puts "Adding exam_request_data to claim: #{claim.id}  (ExamRequest: #{exam_request.id.to_s})" if Rails.env.production? || Rails.env.development?
            end
          end
        end
      rescue Exception => e
        puts "#{e.message} (ExamRequest: #{exam_request.id.to_s})" if Rails.env.production? || Rails.env.development?
        Rails.logger.info "Rescued #{e.inspect} -- ExamRequest #{exam_request.id} has a dangling claim id."
      end
    end
  end
end
