# lib/tasks/cpp.rake
# CPP-specific tasks
#

namespace :cpp do

  desc "Run all tests on the CPP feature set"
  task test: [:environment, 'db:klone'] do
    # TODO: Currently we are only testing models; when the other
    #       tests in the automated suite get updated change the
    #       -P option.
    #
    # TODO: Getting mixed results when --order is random.  This is
    #       an indicator that the tests are not stand-alone.
    command   = <<~CMD
      cd #{Rails.root}
      rspec -P "spec/{models,services}/**/*_{test,spec}.rb"  --order defined --tag cpp
    CMD
    puts "Executing Command: #{command}"
    system command
    exit($?.exitstatus) # NOTE: Passing on the exit code from the rspec command
  end # task test: [:environment, 'db:klone'] do

end # namespace :cpp do
