# lib/npi_validator.rb

# A common validation class for the NPI
class NpiValidator < ActiveModel::Validator

  # Used by validates_with clause in an ActiveRecord Model
  def validate(record)
    @record     = record
    @npi        = record.npi

    ([Array, String].include?(@npi.class)) ? verify_npi : add_error("System Error: NpiValidator.validate called with bad object: #{@npi} of class #{@npi.class}")

  end # def validate(record)


  def verify_npi
    npi_array = convert_to_array
    if npi_array.empty?
      add_error("At least one valid NPI must be entered for this user role")
    else
      npi_array.each do |this_npi|
        if this_npi =~ /\d+/
          # NpiRegistry checks the Provider model first; then the web service and returns nil on bad NPI
          # It has a side-effect of caching NPI records in the providers table.
          add_error("#{this_npi} does not exist") if NpiRegistry.filter(npi: this_npi).nil?
        else
          add_error("NPI '#{this_npi}' is invalid; must be all digits")
        end # if this_npi =~ /\d+/
      end
    end
  end


  def convert_to_array
    ((String == @npi.class) ? @npi.split(/[^\d]/) : @npi).uniq.reject{|entry| entry.blank?}
  end


  def add_error(message)
    @record.errors.add(:npi, message)
  end

end # class NpiValidator < ActiveModel::Validator
