#CS   NOT IN IEPD USAGE GUIDE
#cs
#cs   VA Disability Assessment Hand
#cs
#cs

  THE_SET_OF_VBMS_R_FACT_GROUP_VALUES =
  [
    { 
      name: "Endocrine Facts",                                # Exam Response IEPD Usage Guide, v16.0, 3.2.1
      namespace: "endf",
      fact_block_tag_name: "endocrineFacts",
      diagnosis_tag_name: "endocrineDiagnoses",
      symptom_tag_name: "endocrineSymptoms",
      document_title: "VA Disability Assessment Endocrine",
      additional_fields: {},
      diagnosis_info:
      {
        '7908' => { diagnosis_string: "Acromegaly", modifiers: {} },
        '7911' => { diagnosis_string: "Addison's disease", modifiers: {} },
#        'TBD' => { diagnosis_string: "Adrenal cortical hypofunction", modifiers: {} },
        '7919' => { diagnosis_string: "C-cell hyperplasia of the thyroid", modifiers: {} },
        '7907' => { diagnosis_string: "Cushing's syndrome", modifiers: {} },
        '7909' => { diagnosis_string: "Diabetes insipidus", modifiers: {} },
        '7913' => { diagnosis_string: "Diabetes mellitus", modifiers: {} },
#        'TBD' => { diagnosis_string: "Hyperaldosteronism - benign", modifiers: {} },
#        'TBD' => { diagnosis_string: "Hyperaldosteronism - malignant", modifiers: {} },
        '7904' => { diagnosis_string: "Hyperparathyroidism", modifiers: {} },
#        'TBD' => { diagnosis_string: "Hyperpituitarism - benign", modifiers: {} },
#        'TBD' => { diagnosis_string: "Hyperpituitarism - malignant", modifiers: {} },
        '7900' => { diagnosis_string: "Hyperthyroidism", modifiers: {} },
        '7905' => { diagnosis_string: "Hypoparathyroidism", modifiers: {} },
        '7903' => { diagnosis_string: "Hypothyroidism", modifiers: {} },
        '7915' => { diagnosis_string: "Neoplasm, benign, any specified part of the endocrine system", modifiers: {} },
        '7914' => { diagnosis_string: "Neoplasm, malignant, any specified part of the endocrine system", modifiers: {} },
#        'TBD' => { diagnosis_string: "Pheochromocytoma - benign", modifiers: {} },
#        'TBD' => { diagnosis_string: "Pheochromocytoma - malignant", modifiers: {} },
        '7912' => { diagnosis_string: "Pluriglandular syndrome", modifiers: {} },
#        'TBD' => { diagnosis_string: "Prolactin secreting pituitary dysfunction - benign", modifiers: {} },
#        'TBD' => { diagnosis_string: "Prolactin secreting pituitary dysfunction - malignant", modifiers: {} },
        '7902' => { diagnosis_string: "Thyroid gland, nontoxic adenoma of", modifiers: {} },
        '7901' => { diagnosis_string: "Thyroid gland, toxic adenoma of", modifiers: {} }
      },
      symptom_info:
      {
        'endocrine_fatigability' =>  "Weakness and fatigability",
        'endocrine_anorexia' =>  "Anorexia",
        'endocrine_constipation' =>  "Constipation",
        'endocrine_kidney_stones' =>  "Kidney stones",
        'endocrine_nausea' =>  "Nausea",
        'endocrine_peptic_ulcer' =>  "Peptic ulcer",
        'endocrine_weakness' =>  "Weakness",
        'endocrine_weight_loss' =>  "Weight loss",
        'endocrine_gastrointestinal_symptoms' =>  "Gastrointestinal symptoms",
        'endocrine_cataract' =>  "Cataract",
        'endocrine_cold_intolerance' =>  "Cold intolerance",
        'endocrine_dementia' =>  "Dementia",
        'endocrine_depression' =>  "Depression",
        'endocrine_fatigability' =>  "Fatigability",
        'endocrine_muscular_weakness' =>  "Muscular weakness",
        'endocrine_sleepiness' =>  "Sleepiness",
        'endocrine_slowing_of_thought' =>  "Slowing of thought",
        'endocrine_weight_gain' =>  "Weight gain",
        'endocrine_mental_sluggishness' =>  "Mental sluggishness",
        'endocrine_hypertension' =>  "Hypertension",
        'endocrine_moon_face' =>  "Moon face",
        'endocrine_obesity' =>  "Obesity",
        'endocrine_striae' =>  "Striae",
        'endocrine_vascular_fragility' =>  "Vascular fragility",
        'endocrine_tachycardia' =>  "Tachycardia",
        'endocrine_tremor' =>  "Tremor",
        'endocrine_increased_blood_pressure' =>  "Increased blood pressure",
        'endocrine_increased_pulse_pressure' =>  "Increased pulse pressure"
      }
    },

    { 
      name: "Genitourinary Facts",                                # Exam Response IEPD Usage Guide, v16.0, 3.2.2
      namespace: "guf",                                           # ExamResponse-4.0.xsd
      fact_block_tag_name: "genitourinaryFacts",                  # ExamResponse-4.0.xsd
      diagnosis_tag_name: "genitourinaryDiagnoses",               # GenitourinaryFacts-1.2.xsd
      symptom_tag_name: "genitourinarySymptoms",                  # GenitourinaryFacts-1.2.xsd
      document_title: "VA Disability Assessment Genitourinary",
      additional_fields: {},
      diagnosis_info:
      {
        '7534' => { diagnosis_string: "Atherosclerotic renal disease", modifiers: {} },
        '7529' => { diagnosis_string: "Benign neoplasms", modifiers: {} },
        '7515' => { diagnosis_string: "Bladder, calculus", modifiers: {} },
#        '7516' => { diagnosis_string: "Bladder, fistula", modifiers: {} },
        '7516' => { diagnosis_string: "Bladder, fistula", modifiers: {  'albumin_constant_or_recurring_with_hyaline_and_granular_casts_or_red_blood_cells' =>
                                                                          { :fields  => ["genitourinarySymptoms","value"],
                                                                            :strings => { '' => "Albumin constant or recurring with hyaline and granular casts or red blood cells" } },
                                                                        'bladder_fistula_awakening_to_void' =>
                                                                          { :fields  => ["genitourinarySymptoms","value"],
                                                                            :strings => { 'Awakening to void five or more times per night'  => "Awakening to void five or more times per night",
                                                                                          'Awakening to void three to four times per night' => "Awakening to void three to four times per night",
                                                                                          'Awakening to void two times per night'           => "Awakening to void two times per night"            } } } },
        '7517' => { diagnosis_string: "Bladder, injury", modifiers: {} },
        '7512' => { diagnosis_string: "Cystitis, chronic", modifiers: {} },
        '7540' => { diagnosis_string: "Disseminated intravascular coagulation with renal cortical necrosis", modifiers: {} },
        '7525' => { diagnosis_string: "Epididymo-orchitis, chronic only", modifiers: {} },
        #'TBD' => { diagnosis_string: "Erectile dysfunction", modifiers: {} },
        '7536' => { diagnosis_string: "Glomerulonephritis", modifiers: {} },
        '7509' => { diagnosis_string: "Hydronephrosis", modifiers: {} },
        '7537' => { diagnosis_string: "Interstitial nephritis", modifiers: {} },
#        'TBD' => { diagnosis_string: "Kidney stones", modifiers: {} },
        '7531' => { diagnosis_string: "Kidney transplant", modifiers: {} },
        '7501' => { diagnosis_string: "Kidney, abscess", modifiers: {} },
        '7500' => { diagnosis_string: "Kidney, removal", modifiers: {} },  # removal of one? Diagnosis Modifier?
        '7533' => { diagnosis_string: "Kidneys, cystic diseases", modifiers: {} },
        '7528' => { diagnosis_string: "Malignant neoplasms", modifiers: {} },
        '7502' => { diagnosis_string: "Nephritis, chronic", modifiers: {} },
        '7508' => { diagnosis_string: "Nephrolithiasis", modifiers: {} },
        '7507' => { diagnosis_string: "Nephrosclerosis, arteriolar", modifiers: {} },
        '7542' => { diagnosis_string: "Neurogenic bladder", modifiers: {} },
        '7538' => { diagnosis_string: "Papillary necrosis", modifiers: {} },
#        'TBD' => { diagnosis_string: "Penile disability", modifiers: {} },
        '7527' => { diagnosis_string: "Prostate gland", modifiers: {} },
        '7504' => { diagnosis_string: "Pyelonephritis, chronic", modifiers: {} },
        '7539' => { diagnosis_string: "Renal amyloid disease", modifiers: {} },
        '7530' => { diagnosis_string: "Renal disease, chronic", modifiers: {} },
        '7541a' => { diagnosis_string: "Renal involvement in diabetes mellitus", modifiers: {} },   # Diagnosis Modifier needed to differentiate diagnoses
        '7541b' => { diagnosis_string: "Renal involvement in sickle cell anemia", modifiers: {} },
        '7541c' => { diagnosis_string: "Renal involvement in systemic diseases", modifiers: {} },
        '7541d' => { diagnosis_string: "Renal involvement in systemic lupus erythematosus", modifiers: {} },
        '7541e' => { diagnosis_string: "Renal involvement in vasculitis", modifiers: {} },
        '7532' => { diagnosis_string: "Renal tubular disorders", modifiers: {} },
#        'TBD' => { diagnosis_string: "Testis disability", modifiers: {} },
        '7535' => { diagnosis_string: "Toxic nephropathy", modifiers: {} },
        '7505' => { diagnosis_string: "Tuberculosis of the kidney", modifiers: {} },
        '7511' => { diagnosis_string: "Ureter, stricture", modifiers: {} },
        '7510' => { diagnosis_string: "Ureterolithiasis", modifiers: {} },
        '7519' => { diagnosis_string: "Urethra, fistula", modifiers: {} },
        '7518' => { diagnosis_string: "Urethra, stricture", modifiers: {} }
      },
      symptom_info:
      {
      }
    },

    { 
      name: "Hearing Loss Facts",                                 # Exam Response IEPD Usage Guide, v16.0, 3.2.3
      namespace: "hl",                                            # ExamResponse-4.0.xsd
      fact_block_tag_name: "hearingLoss",                         # ExamResponse-4.0.xsd
      diagnosis_tag_name: "Non-existent in schema",               # HearingLoss-1.2.xsd
      symptom_tag_name: "Non-existent in schema",                 # HearingLoss-1.2.xsd
      document_title: "VA Disability Assessment Hearing Loss",
      additional_fields: {},
      diagnosis_info:
      {
      },
      symptom_info:
      {
      }
    },

    { 
      name: "Ear Disease and Other Sense Organs Facts",         # Exam Response IEPD Usage Guide, v16.0, 3.2.4
      namespace: "Non-existent in schema",                      # ExamResponse-4.0.xsd     
      fact_block_tag_name: "Non-existent in schema",            # ExamResponse-4.0.xsd         
      diagnosis_tag_name: "TBD",
      symptom_tag_name: "TBD",
      document_title: "VA Disability Assessment Ear Diseease and Other Sense Organs",
      additional_fields: {},
      diagnosis_info:
      {
      },
      symptom_info:
      {
      }
    },

    { 
      name: "Infectious Disease Facts",                                 # Exam Response IEPD Usage Guide, v16.0, 3.2.5
      namespace: "cbsf",                                                # ExamResponse-4.0.xsd
      fact_block_tag_name: "commonBodySystemFacts",                     # ExamResponse-4.0.xsd
      diagnosis_tag_name: "diagnoses",                                  # CommonBodySystemFacts-2.0.xsd
      symptom_tag_name: "symptoms",                                     # CommonBodySystemFacts-2.0.xsd
      document_title: "VA Disability Assessment Infectious Diseases",
      additional_fields: {"commonType" => "InfectiousDiseases"},        # Exam Response IEPD Usage Guide, v16.0, 3.2.5
      diagnosis_info:
      {
        '6313' => { diagnosis_string: "Avitaminosis", modifiers: {} },
        '6315' => { diagnosis_string: "Pellagra", modifiers: {} },
        '6306' => { diagnosis_string: "Bartonellosis", modifiers: {} },
        '6317' => { diagnosis_string: "Typhus, scrub", modifiers: {} },
        '6300' => { diagnosis_string: "Cholera, asiatic", modifiers: {} },
        '6314' => { diagnosis_string: "Beriberi ", modifiers: {} },
        '6316' => { diagnosis_string: "Brucellosis", modifiers: {} },
        '6302' => { diagnosis_string: "Hansen's Disease Leprosy", modifiers: {} },
        '6319' => { diagnosis_string: "Lyme Disease", modifiers: {} },
        '6305' => { diagnosis_string: "Lymphatic Filariasis", modifiers: {} },
        '6304' => { diagnosis_string: "Malaria", modifiers: {} },
        '6318' => { diagnosis_string: "Melioidosis", modifiers: {} },
        '6320' => { diagnosis_string: "Parasitic diseases otherwise not specified", modifiers: {} },
        '6307' => { diagnosis_string: "Plague", modifiers: {} },
        '6308' => { diagnosis_string: "Relapsing Fever", modifiers: {} },
        '6309' => { diagnosis_string: "Rheumatic Fever", modifiers: {} },
        '6301' => { diagnosis_string: "Visceral Leishmaniasis", modifiers: {} },
        '6354' => { diagnosis_string: "Chronic Fatigue Syndrome (CFS)", modifiers: {} },
        '6351' => { diagnosis_string: "HIV-Related Illness", modifiers: {} },
        '6350' => { diagnosis_string: "Lupus erythematosus, systemic (disseminated)", modifiers: {} },
        '6310' => { diagnosis_string: "Syphilis, and other treponemal infections ", modifiers: {} }
#not in eCFR: Tuberculosis, miliary
      },
      symptom_info:
      {
        'infectious_diarrhea' =>  "Diarrhea",
        'infectious_exhaustion' =>  "Exhaustion",
        'infectious_impaired_bodily_vigor' =>  "Impaired bodily vigor",
	'infectious_mental_symptoms' =>  "Mental symptoms",
	'infectious_moist_dermatitis' =>  "Moist dermatitis",
	'infectious_memory_loss' =>  "Memory loss",
	'infectious_oral_candidiasis' =>  "Oral Candidiasis",
	'infectious_evidence_of_depression' =>  "Evidence of depression",
	'infectious_weakness' =>  "Active disease with symptoms such as weakness",
	'infectious_stiffness_of_legs' =>  "Active disease with symptoms such as stiffness of legs",
	'infectious_sleep_disturbance' =>  "Active disease with symptoms such as sleep disturbance",
	'infectious_heaviness' =>  "Active disease with symptoms such as heaviness",
	'infectious_headache' =>  "Active disease with symptoms such as headache",
	'infectious_fatigue' =>  "Active disease with symptoms such as fatigue",
	'infectious_dizziness' =>  "Active disease with symptoms such as dizziness",
        'infectious_anorexia' =>  "Active disease with symptoms such as anorexia"
      }
    },

    { 
      name: "Cardiovascular Facts",                    # Exam Response IEPD Usage Guide, v16.0, 3.2.6
      namespace: "cvf",                                # ExamResponse-4.0.xsd
      fact_block_tag_name: "cardiovascularFacts",      # ExamResponse-4.0.xsd
      diagnosis_tag_name: "cardiovascularDiagnoses",   # CardiovascularFacts-1.2.xsd
      symptom_tag_name: "cardiovascularSymptoms",      # CardiovascularFacts-1.2.xsd
      document_title: "VA Disability Assessment Cardiovascular",
      additional_fields: {},                           
      diagnosis_info:
      {
        '7111' => { diagnosis_string: "Aneurysm, any large artery", modifiers: {} },
        '7112' => { diagnosis_string: "Aneurysm, any small artery", modifiers: {} },
        '7118' => { diagnosis_string: "Angioneurotic edema", modifiers: {} },
        '7110' => { diagnosis_string: "Aortic aneurysm", modifiers: {} },
        '7114' => { diagnosis_string: "Arteriosclerosis obliterans", modifiers: {} },
        '7005' => { diagnosis_string: "Arteriosclerotic heart disease", modifiers: {} },
        '7113' => { diagnosis_string: "Arteriovenous fistula, traumatic", modifiers: {} },
        '7015' => { diagnosis_string: "Atrioventricular block", modifiers: {} },
        '7115a' => { diagnosis_string: "Buerger's Disease", modifiers: {} },
        '7019' => { diagnosis_string: "Cardiac transplantation", modifiers: {} },
        '7020' => { diagnosis_string: "Cardiomyopathy", modifiers: {} },
        '7122' => { diagnosis_string: "Cold injury residuals", modifiers: {} },
        #'TBD' => { diagnosis_string: "Coronary artery bypass graft (CABG)", modifiers: {} },
        '7005' => { diagnosis_string: "Coronary artery disease", modifiers: {} },
        '7017' => { diagnosis_string: "Coronary bypass surgery", modifiers: {} },
        '7001' => { diagnosis_string: "Endocarditis", modifiers: {} },
        '7119' => { diagnosis_string: "Erythromelalgia", modifiers: {} },
        '7016' => { diagnosis_string: "Heart valve replacement (prosthesis)", modifiers: {} },
        #'TBD' => { diagnosis_string: "Hypertension", modifiers: {} },
        '7007' => { diagnosis_string: "Hypertensive heart disease", modifiers: {} },
        '7101' => { diagnosis_string: "Hypertensive Vascular Disease", modifiers: {} },
        '7008' => { diagnosis_string: "Hyperthyroid heart disease", modifiers: {} },
        '7018' => { diagnosis_string: "Implantable cardiac pacemaker", modifiers: {} },
        #'TBD' => { diagnosis_string: "Implantable Cardioverter-Defibrillator (AICD)", modifiers: {} },
        #'TBD' => { diagnosis_string: "Isolated systolic hypertension", modifiers: {} },
        '7006' => { diagnosis_string: "Myocardial infarction", modifiers: {} },
        '7003' => { diagnosis_string: "Pericardial adhesions", modifiers: {} },
        '7002' => { diagnosis_string: "Pericarditis", modifiers: {} },
        '7121' => { diagnosis_string: "Post-phlebitic syndrome of any etiology", modifiers: {} },
        '7117' => { diagnosis_string: "Raynaud's syndrome", modifiers: {} },
        '7000a' => { diagnosis_string: "Rheumatic heart disease", modifiers: {} },
        '7123' => { diagnosis_string: "Soft tissue sarcoma (of vascular origin)", modifiers: {} },
        '7010' => { diagnosis_string: "Supraventricular arrhythmias", modifiers: {} },
        '7004' => { diagnosis_string: "Syphilitic heart disease", modifiers: {} },
        '7115b' => { diagnosis_string: "Thrombo-angiitis obliterans", modifiers: {} },
        '7000b' => { diagnosis_string: "Valvular heart disease", modifiers: {} },
        '7120' => { diagnosis_string: "Varicose veins", modifiers: {} },
        '7011' => { diagnosis_string: "Ventricular arrhythmias (sustained)", modifiers: {} }
      },
      symptom_info:
      {
        'arteries_and_veins_diminished_peripheral_pulses' =>  "Diminished peripheral pulses",
        'arteries_and_veins_precluding_exertion' =>  "Precluding exertion",
        'arteries_and_veins_persistent_coldness_of_the_extremity' =>  "Persistent coldness of the extremity",
        'arteries_and_veins_cold_sensitivity' =>  "Cold sensitivity",
        'arteries_and_veins_color_changes' =>  "Color changes",
        'arteries_and_veins_hyperhidrosis' =>  "Hyperhidrosis",
        'arteries_and_veins_locally_impaired_sensation' =>  "Locally impaired sensation",
        'arteries_and_veins_nail_abnormalities' =>  "Nail abnormalities",
        'arteries_and_veins_numbness' =>  "Numbness",
        'arteries_and_veins_osteoporosis' =>  "Osteoporosis",
        'arteries_and_veins_osteoarthritis' =>  "Osteoarthritis",
        'arteries_and_veins_pain' =>  "Pain",
        'arteries_and_veins_subarticular_punched_out_lesions' =>  "Subarticular punched out lesions",
        'arteries_and_veins_tissue_loss' =>  "Tissue loss"
      }
    },

    { 
      name: "Cervical Spine Facts",         # Exam Response IEPD Usage Guide, v16.0, 3.2.7
      namespace: "spf",
      fact_block_tag_name: "spineFacts",
      diagnosis_tag_name: "spineDiagnoses",
      symptom_tag_name: "spineSymptoms",
      document_title: "VA Disability Assessment Cervical Spine",
      additional_fields: {},
      diagnosis_info:
      {
# There is no way (based on diagnoses) to differentiate between Thoracolumbar Spine and Cervical Spine. It is all 'Spine' in the eCFR
#        'TBD' => { diagnosis_string: "TBD", modifiers: {} },
#        'TBD' => { diagnosis_string: "TBD", modifiers: {} }
      },
      symptom_info:
      {
      }
    },

    { 
      name: "Thoracolumbar Spine Facts",         # Exam Response IEPD Usage Guide, v16.0, 3.2.8
      namespace: "spf",
      fact_block_tag_name: "spineFacts",
      diagnosis_tag_name: "spineDiagnoses",
      symptom_tag_name: "spineSymptoms",
      document_title: "VA Disability Assessment Thoracolumbar Spine",
      additional_fields: {},
      diagnosis_info:
      {
# There is no way (based on diagnoses) to differentiate between Thoracolumbar Spine and Cervical Spine. It is all 'Spine' in the eCFR
#        'TBD' => { diagnosis_string: "TBD", modifiers: {} },
#        'TBD' => { diagnosis_string: "TBD", modifiers: {} }
      },
      symptom_info:
      {
      }
    },

    { 
      name: "Traumatic Brain Injury (TBI) Facts",         	# Exam Response IEPD Usage Guide, v16.0, 3.2.9
      namespace: "tbif",									# ExamResponse-4.0.xsd
      fact_block_tag_name: "tbiFacets",						# ExamResponse-4.0.xsd
      diagnosis_tag_name: "Does not exist in the schema",
      symptom_tag_name: "Does not exist in the schema",
      document_title: "VA Disability Assessment Traumatic Brain Injury",
      additional_fields: {},
      diagnosis_info:
      {
		#'TBD' => { diagnosis_string: "Traumatic brain injury (TBI)", modifiers: {} 
      },
      symptom_info:
      {
      }
    },

    { 
      name: "Respiratory Facts",         # Exam Response IEPD Usage Guide, v16.0, 3.2.10 (DO THIS NOW)
      namespace: "rf",													# ExamResponse-4.0.xsd
      fact_block_tag_name: "respiratoryFacts",							# ExamResponse-4.0.xsd
      diagnosis_tag_name: "respiratoryDiagnoses",                       # RespiratoryFacts-1.1.xsd
      symptom_tag_name: "respiratorySymptoms",                          # RespiratoryFacts-1.1.xsd
      document_title: "VA Disability Assessment Respiratory",
      additional_fields: {},
      diagnosis_info:
      {
		'6822' => { diagnosis_string: "Actinomycosis", modifiers: {} },
		'6522' => { diagnosis_string: "Allergic or vasomotor rhinitis", modifiers: {} },
		'6519' => { diagnosis_string: "Aphonia", modifiers: {} },
		'6833' => { diagnosis_string: "Asbestosis", modifiers: {} },
		'6838' => { diagnosis_string: "Aspergillosis", modifiers: {} },
		'6602' => { diagnosis_string: "Asthma, bronchial", modifiers: {} },
		'6523' => { diagnosis_string: "Bacterial rhinitis", modifiers: {} },
		'6836' => { diagnosis_string: "Blastomycosis", modifiers: {} },
		'6601' => { diagnosis_string: "Bronchiectasis", modifiers: {} },
		'6600' => { diagnosis_string: "Bronchitis, chronic", modifiers: {} },
		'6824' => { diagnosis_string: "Chronic lung abscess", modifiers: {} },
		'6604' => { diagnosis_string: "Chronic obstructive pulmonary disease", modifiers: {} },
		'6835' => { diagnosis_string: "Coccidioidomycosis", modifiers: {} },
		'6837' => { diagnosis_string: "Cryptococcosis", modifiers: {} },
		'6826' => { diagnosis_string: "Desquamative interstitial pneumonitis", modifiers: {} },
		'6502' => { diagnosis_string: "Deviated nasal septum", modifiers: {} },
		'6840a' => { diagnosis_string: "Diaphragm paralysis", modifiers: {} },		#FIX_ME: Chip, This is a diagnosis modifier
		'6840b' => { diagnosis_string: "Diaphragm paresis", modifiers: {} },		#FIX_ME: Chip, This is a diagnosis modifier
		'6829' => { diagnosis_string: "Drug-induced, pneumonitis & fibrosis", modifiers: {} },
		'6603' => { diagnosis_string: "Emphysema, pulmonary", modifiers: {} },
		'6828' => { diagnosis_string: "Eosinophilic granuloma", modifiers: {} },
		'6825' => { diagnosis_string: "Fibrosis of lung, diffuse interstitial", modifiers: {} },
		'6524' => { diagnosis_string: "Granulomatous rhinitis", modifiers: {} },
		'6834' => { diagnosis_string: "Histoplasmosis", modifiers: {} },
		'6831' => { diagnosis_string: "Hypersensitivity pneumonitis (extrinsic allergic alveolitis)", modifiers: {} },
		'6842' => { diagnosis_string: "Kyphoscoliosis, pectus excavatum / carinatum", modifiers: {} },
		'6518' => { diagnosis_string: "Laryngectomy", modifiers: {} },
		'6516' => { diagnosis_string: "Laryngitis, chronic", modifiers: {} },
		'6515' => { diagnosis_string: "Laryngitis, tuberculous", modifiers: {} },
		'6520' => { diagnosis_string: "Larynx, stenosis of", modifiers: {} },
		'6839' => { diagnosis_string: "Mucormycosis", modifiers: {} },
		#'TBD' => { diagnosis_string: "Neoplasms, malignant", modifiers: {} },
		'6823' => { diagnosis_string: "Nocardiosis", modifiers: {} },
		'6504' => { diagnosis_string: "Nose, loss of part of, or scars", modifiers: {} },
		'6847' => { diagnosis_string: "Obstructive sleep apnea", modifiers: {} },
		'6521' => { diagnosis_string: "Pharynx, injuries to", modifiers: {} },
		'6845' => { diagnosis_string: "Pleural effusion or fibrosis", modifiers: {} },
		'6732' => { diagnosis_string: "Pleurisy, active or inactive", modifiers: {} },
		'6832' => { diagnosis_string: "Pneumoconiosis (silicosis anthracosis etc.)", modifiers: {} },
		'6844' => { diagnosis_string: "Post-surgical residual (lobectomy, pneumonectomy, etc.)", modifiers: {} },
		'6827' => { diagnosis_string: "Pulmonary alveolar proteinosis", modifiers: {} },
		'6603' => { diagnosis_string: "Pulmonary emphysema", modifiers: {} },
		'6817' => { diagnosis_string: "Pulmonary vascular disease", modifiers: {} },
		'6830' => { diagnosis_string: "Radiation-induced, pneumonitis & fibrosis", modifiers: {} },
		'6846' => { diagnosis_string: "Sarcoidosis", modifiers: {} },
		#'TBD' => { diagnosis_string: "Septum, nasal, deviation", modifiers: {} },		#FIX_ME: Chip. Duplicate of "Deviated nasal septum" (see above)
		'6511' => { diagnosis_string: "Sinusitis, ethmoid, chronic", modifiers: {} },
		'6512' => { diagnosis_string: "Sinusitis, frontal, chronic", modifiers: {} },
		'6513' => { diagnosis_string: "Sinusitis, maxillary, chronic", modifiers: {} },
		'6510' => { diagnosis_string: "Sinusitis, pansinusitis, chronic", modifiers: {} },
		'6514' => { diagnosis_string: "Sinusitis, sphenoid, chronic", modifiers: {} },
		#'TBD' => { diagnosis_string: "Sleep apnea syndrome", modifiers: {} },				#FIX_ME: Chip. Duplicate of "Sleep Apnea Syndromes" (see above)
		'6841' => { diagnosis_string: "Spinal cord injury with respiratory insufficiency", modifiers: {} },
		'6843' => { diagnosis_string: "Traumatic chest wall defect", modifiers: {} }
		#'TBD' => { diagnosis_string: "Tuberculosis", modifiers: {} }		#FIX_ME: Chip. Diagnoses modifiers? 6701, 6702, 6703, 6704, 6721, 6722, 6723, 6724, 6730, 6731, 6732
      },
      symptom_info:
      {
        'carbon_dioxide_retention'  => "Carbon dioxide retention",
        'cor_pulmonale'             => "Cor pulmonale",
        'diseases_of_the_nose_and_throat_constant_inability_to_communicate_by_speech' =>  "Constant inability to communicate by speech",
        'diseases_of_the_nose_and_throat_constant_inability_to_speak_above_a_whisper' =>  "Constant inability to speak above a whisper",
        'diseases_of_the_nose_and_throat_hoarseness' =>  "Hoarseness",
        'diseases_of_the_nose_and_throat_inflammation_of_cords' =>  "Inflammation of cords",
        'diseases_of_the_nose_and_throat_inflammation_of_the_mucous_membrane' =>  "Inflammation of the mucous membrane",
        'diseases_of_the_nose_and_throat_nodules_of_cords' =>  "Nodules of cords",
        'diseases_of_the_nose_and_throat_polyps' =>  "Polyps",
        'diseases_of_the_nose_and_throat_submucous_infiltration' =>  "Submucous infiltration",
        'diseases_of_the_nose_and_throat_thickening_of_cords' =>  "Thickening of cords",
        'diseases_of_the_trachea_and_bronchi' =>  "Anorexia",
        'diseases_of_the_trachea_and_bronchi_weight_loss' =>  "Weight loss",
        'bacterial_infections_of_the_lung_fever' =>  "Active infection with systemic symptoms such as fever, night sweats, weight loss, or hemoptysis",
        'bacterial_infections_of_the_lung_night_sweats' =>  "Active infection with systemic symptoms such as fever, night sweats, weight loss, or hemoptysis",
        'bacterial_infections_of_the_lung_weight_loss' =>  "Active infection with systemic symptoms such as fever, night sweats, weight loss, or hemoptysis",
        'bacterial_infections_of_the_lung_hemopytis' =>  "Active infection with systemic symptoms such as fever, night sweats, weight loss, or hemoptysis",
        'bacterial_infections_of_the_lung_active_infection' =>  "Active infection with systemic symptoms such as fever, night sweats, weight loss, or hemoptysis",
        'mycotic_lung _disease_productive_cough' =>  "Minimal symptoms such as occasional minor hemoptysis or productive cough",
        'mycotic_lung_disease_night_sweats' =>  "Night sweats",
        'mycotic_lung_disease_persistent_fever' =>  "Persistent fever",
        'mycotic_lung_disease_weight_loss' =>  "Weight loss",
        'mycotic_lung_disease_minor_hemoptysis' =>  "Minimal symptoms such as occasional minor hemoptysis or productive cough"
      }
    },


    # Organic Diseases of the Central Nervous System (FROM THE SPREADSHEET)
    { 
      name: "Neurological Other Facts",         # Exam Response IEPD Usage Guide, v16.0, 3.2.11
      namespace: "nof",
      fact_block_tag_name: "neurologicalOtherFacts",
      diagnosis_tag_name: "neurologicalOtherDiagnoses",
      symptom_tag_name: "neurologicalOtherSymptoms",
      document_title: "VA Disability Assessment Neurological Other",
      additional_fields: {},
      diagnosis_info:
      {
        '8017' => { diagnosis_string: "Amyotrophic lateral sclerosis", modifiers: {} },
        '8107' => { diagnosis_string: "Athetosis, acquired", modifiers: {} },
        '8106' => { diagnosis_string: "Chorea, Huntington's", modifiers: {} },
        '8105' => { diagnosis_string: "Chorea, Sydenham's", modifiers: {} },
        #'TBD' => { diagnosis_string: "Huntington's Chorea", modifiers: {} },      # This is the same as 'Chorea, Huntington's'. See two lines above
        #'TBD' => { diagnosis_string: "Sydenham's Chorea", modifiers: {} },        # This is the same as 'Chorea, Sydenham's'. See two lines above
        #'TBD' => { diagnosis_string: "Benign (Brain)", modifiers: {} },
        #'TBD' => { diagnosis_string: "Benign (Spinal Cord)", modifiers: {} },
        '8020' => { diagnosis_string: "Brain, abscess", modifiers: {} },
        '8007' => { diagnosis_string: "Brain, vessels, embolism", modifiers: {} },
        '8009' => { diagnosis_string: "Brain, vessels, hemorrhage", modifiers: {} },
        '8008' => { diagnosis_string: "Brain, vessels, thrombosis", modifiers: {} },
        '8012' => { diagnosis_string: "Hematomyelia", modifiers: {} },
        '8005' => { diagnosis_string: "Bulbar palsy", modifiers: {} },
        '8046' => { diagnosis_string: "Cerebral arteriosclerosis", modifiers: {} },
        '8104a' => { diagnosis_string: "Convulsive state, myoclonic type", modifiers: {} }, #FIX_ME: This needs a diagnoses modifier
        '8104b' => { diagnosis_string: "Paramyoclonus multiplex", modifiers: {} },          #FIX_ME: This needs a diagnoses modifier
        '8103' => { diagnosis_string: "Tic, convulsive", modifiers: {} },
        #'TBD' => { diagnosis_string: "Cranial Nerve", modifiers: {} },                     #FIX_ME: This needs a diagnoses modifier (568 to 579 in the excel sheet)
        #'TBD' => { diagnosis_string: "Peripheral Nerve", modifiers: {} },					#FIX_ME: Chip. There is a minor system with the name 'Diseases of the Peripheral Nerves'. Need clarification. This will be a special case
        '8000' => { diagnosis_string: "Encephalitis, epidemic, chronic", modifiers: {} },
        '8019' => { diagnosis_string: "Meningitis, cerebrospinal, epidemic", modifiers: {} },
        '8011' => { diagnosis_string: "Poliomyelitis, anterior", modifiers: {} },
        '8912a' => { diagnosis_string: "Epilepsy, Jacksonian", modifiers: {} },
        '8913' => { diagnosis_string: "Epilepsy, diencephalic", modifiers: {} },
        '8912b' => { diagnosis_string: "Epilepsy, focal motor", modifiers: {} },
        '8910' => { diagnosis_string: "Epilepsy, grand mal", modifiers: {} },
        '8911' => { diagnosis_string: "Epilepsy, petit mal", modifiers: {} },
        '8914' => { diagnosis_string: "Epilepsy, psychomotor", modifiers: {} },
        '8912c' => { diagnosis_string: "Epilepsy, sensory", modifiers: {} },
        '8108' => { diagnosis_string: "Narcolepsy", modifiers: {} },
        '8002' => { diagnosis_string: "Malignant (Brain)", modifiers: {} },						# It looks like 8021 is a duplicate of 8002
        #'TBD' => { diagnosis_string: "Malignant (Spinal Cord)", modifiers: {} },
        '8100' => { diagnosis_string: "Migraines", modifiers: {} },
        '8018' => { diagnosis_string: "Multiple sclerosis", modifiers: {} },
        '8025' => { diagnosis_string: "Myasthenia gravis", modifiers: {} },
        '8010' => { diagnosis_string: "Myelitis", modifiers: {} },
        '8004' => { diagnosis_string: "Paralysis agitans", modifiers: {} },
        #'TBD' => { diagnosis_string: "Parkinson's disease", modifiers: {} },
        '8023' => { diagnosis_string: "Progressive muscular atrophy", modifiers: {} },
        '8540' => { diagnosis_string: "Soft-tissue sarcoma (of neurogenic origin)", modifiers: {} },
        '8024' => { diagnosis_string: "Syringomyelia", modifiers: {} },
        '8013' => { diagnosis_string: "Syphilis, cerebrospinal", modifiers: {} },
        '8014' => { diagnosis_string: "Syphilis, meningovascular", modifiers: {} },
        '8015' => { diagnosis_string: "Tabes dorsalis", modifiers: {} },
        '8045' => { diagnosis_string: "Traumatic brain injury (TBI)", modifiers: {} }
      },
      symptom_info:
      {
      }
    },

    { 
      name: "Neurological Conditions and Convulsive Disorders Crainial Peripheral Nerves Facts",         # Exam Response IEPD Usage Guide, v16.0, 3.2.12 (DO THIS NOW)
      namespace: "TBD",					
      fact_block_tag_name: "TBD",		# We couldn't find it in the ExamResponse XSD
      diagnosis_tag_name: "TBD",
      symptom_tag_name: "TBD",
      document_title: "VA Disability Assessment Cranial and Peripheral Nerves",  #cs TBD IS THIS CORRECT??
      additional_fields: {},
      diagnosis_info:
      {
    
    # These are existing. We dont know where they go yet
        
		#'8513' => { diagnosis_string: "All radicular groups", modifiers: {} },  #FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8513, 8613, 8713
		#'8518' => { diagnosis_string: "Circumflex nerve", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8518, 8618, 8718
		#'TBD' => { diagnosis_string: "Cubital tunnel syndrome", modifiers: {} },
		#'8519' => { diagnosis_string: "Long thoracic nerve", modifiers: {} },	#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8519, 8619, 8719
		#'8512' => { diagnosis_string: "Lower radicular group", modifiers: {} },	#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8512, 8612, 8712
		#'8515' => { diagnosis_string: "Median nerve", modifiers: {} },			#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8515, 8615, 8715
		#'8511' => { diagnosis_string: "Middle radicular group", modifiers: {} },	#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8511, 8611, 8711
		#'8517' => { diagnosis_string: "Musculocutaneous nerve", modifiers: {} },	#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8517, 8617, 8717
		#'8514' => { diagnosis_string: "Musculospiral nerve (radial nerve)", modifiers: {} },	#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8514, 8614, 8714
		#'TBD' => { diagnosis_string: "Peripheral neuropathy, upper extremity", modifiers: {} },
		#'8516' => { diagnosis_string: "Ulnar nerve", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8516, 8616, 8716
		#'8510' => { diagnosis_string: "Upper radicular group (fifth and sixth cervicals)", modifiers: {} },	#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8510, 8610, 8710
		#'8526' => { diagnosis_string: "Anterior crural nerve (femoral)", modifiers: {} },	#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8526, 8626, 8726
		#'8523' => { diagnosis_string: "Anterior tibial nerve (deep peroneal)", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8523, 8623, 8723
		#'8211' => { diagnosis_string: "Eleventh (spinal accessory, external branch) cranial nerve", modifiers: {} },	#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8211, 8311, 8411
		#'8529' => { diagnosis_string: "External cutaneous nerve of thigh", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8529, 8629, 8729
		#'8521' => { diagnosis_string: "External popliteal nerve (common peroneal)", modifiers: {} },	#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8521, 8621, 8721
		#'8205' => { diagnosis_string: "Fifth (trigeminal) cranial nerve", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8205, 8305, 8405
		#'8530' => { diagnosis_string: "Ilio-inguinal nerve", modifiers: {} },	#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8530, 8630, 8730
		#'8524' => { diagnosis_string: "Internal popliteal nerve (tibial)", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8524, 8624, 8724
		#'8527' => { diagnosis_string: "Internal saphenous nerve", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8527, 8627, 8727
		#'8517' => { diagnosis_string: "Musculocutaneous nerve (superficial peroneal)", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8517, 8617, 8717
		#'8209' => { diagnosis_string: "Ninth (glossopharyngeal) cranial nerve", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8209, 8309, 8409
		#'8528' => { diagnosis_string: "Obturator nerve", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8528, 8628, 8728
		#'TBD' => { diagnosis_string: "Peripheral neuropathy, lower extremity", modifiers: {} },
		#'8525' => { diagnosis_string: "Posterior tibial nerve", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8525, 8625, 8725
		#'8520' => { diagnosis_string: "Sciatic nerve", modifiers: {} },			#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8520, 8620, 8720
		#'8207' => { diagnosis_string: "Seventh (facial) cranial nerve", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8207, 8307, 8407
		#'8210' => { diagnosis_string: "Tenth (pneumogastric, vagus) cranial nerve", modifiers: {} },	#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8210, 8310, 8410
		#'TBD' => { diagnosis_string: "Tic douloureux", modifiers: {} },
		#'8212' => { diagnosis_string: "Twelfth (hypoglossal) cranial nerve", modifiers: {} },		#FIX_ME: Chip. This should be a diagnoses modifier that gives codes 8212, 8312, 8412
		#'TBD' => { diagnosis_string: "Carpal tunnel syndrome", modifiers: {} },
		#'TBD' => { diagnosis_string: "Traumatic brain injury (TBI)", modifiers: {} }
      },
      symptom_info:
      {
      }
    },

    {
      name: "Mental Disorder Facts",         # Exam Response IEPD Usage Guide, v16.0, 3.2.13
      namespace: "mdf",
      fact_block_tag_name: "mentalDisorderFacts",
      diagnosis_tag_name: "mentalDisorderDiagnoses",
      symptom_tag_name: "mentalDisorderSymptoms",
      document_title: "VA Disability Assessment Mental Disorders",
      additional_fields: {},
      diagnosis_info:
      {
        '9432' => { diagnosis_string: "Bipolar disorder", modifiers: {} },
        '9440' => { diagnosis_string: "Chronic adjustment disorder", modifiers: {} },
        '9424' => { diagnosis_string: "Conversion disorder (functional neurological symptom disorder)", modifiers: {} },
        '9431' => { diagnosis_string: "Cyclothymic disorder", modifiers: {} },
        '9300' => { diagnosis_string: "Delirium", modifiers: {} },
        '9208' => { diagnosis_string: "Delusional disorder", modifiers: {} },
        '9417' => { diagnosis_string: "Depersonalization/Derealization disorder", modifiers: {} },
        '9416a' => { diagnosis_string: "Dissociative amnesia", modifiers: {} },
        '9416b' => { diagnosis_string: "Dissociative identity disorder", modifiers: {} },
        '9400' => { diagnosis_string: "Generalized anxiety disorder", modifiers: {} },
        '9425' => { diagnosis_string: "Illness anxiety disorder", modifiers: {} },
        '9434' => { diagnosis_string: "Major depressive disorder", modifiers: {} },
        '9326' => { diagnosis_string: "Major or mild neurocognitive disorder due to another medical condition or substance/medication induced major or mild neurocognitive disorder", modifiers: {} },
        '9301' => { diagnosis_string: "Major or mild neurocognitive disorder due to HIV or other infections", modifiers: {} },
        '9304' => { diagnosis_string: "Major or mild neurocognitive disorder due to traumatic brain injury", modifiers: {} },
        '9312' => { diagnosis_string: "Major or mild neurocognitive disorder due to Alzheimer's disease", modifiers: {} },
        '9305' => { diagnosis_string: "Major or mild vascular neurocognitive disorder", modifiers: {} },
        '9404' => { diagnosis_string: "Obsessive compulsive disorder", modifiers: {} },
        '9410' => { diagnosis_string: "Other specified anxiety disorder", modifiers: {} },
        '9210' => { diagnosis_string: "Other specified and unspecified schizophrenia spectrum and other psychotic disorders", modifiers: {} },
        '9422' => { diagnosis_string: "Other specified somatic symptom and related disorder", modifiers: {} },
        '9412' => { diagnosis_string: "Panic disorder and/or agoraphobia", modifiers: {
                                                                                'panic_disorder_and_or_agoraphobia_panic_attacks' =>
                                                                          { :fields  => ["mentalDisorderSymptoms","value"],
                                                                            :strings => { 'Panic attacks (less than weekly)'  => "Panic attacks (less than weekly)",
                                                                                          'Panic attacks (weekly)' => "Panic attacks (weekly)",
                                                                                          'Panic attacks more than once a week'           => "Panic attacks more than once a week"            } }
          
        } },

        '9433' => { diagnosis_string: "Persistent depressive disorder (dysthymia)", modifiers: {} },
        '9411' => { diagnosis_string: "Posttraumatic stress disorder", modifiers: {} },
   #     'TBD' => { diagnosis_string: "PTSD", modifiers: {} },
        '9201' => { diagnosis_string: "Schizophrenia", modifiers: {} },
        '9211' => { diagnosis_string: "Schizoaffective disorder", modifiers: {} },
        '9421' => { diagnosis_string: "Somatic symptom disorder", modifiers: {} },
        '9403' => { diagnosis_string: "Specific phobia; social anxiety disorder (social phobia)", modifiers: {} },
        '9413' => { diagnosis_string: "Unspecified anxiety disorder", modifiers: {} },
        '9310' => { diagnosis_string: "Unspecified neurocognitive disorder", modifiers: {} },
        '9435' => { diagnosis_string: "Unspecified depressive disorder", modifiers: {} },
        '9423' => { diagnosis_string: "Unspecified somatic symptom and related disorder", modifiers: {} }
      },
#            diagnosis_modifier_info: (should be 'other element info' here? Diagnosis Modifier is on the evaluation side)
#            {
#              'Severe enough for release' => { '9404' => { diagnosis_modifier_tag_name: "severeEnoughForRelease", value: true } }
#            },
      symptom_info:
      {
        'mental_disorders_anxiety' =>  "Anxiety",
	'mental_disorders_bruxism' =>  "Bruxism",
	'mental_disorders_depressed_mood' =>  "Depressed mood",
	'mental_disorders_forgetting_directions' =>  "Forgetting directions",
	'mental_disorders_forgetting_names' =>  "Forgetting directions",
	'mental_disorders_forgetting_recent_events' =>  "Forgetting directions",
	'mental_disorders_forgetting_to_complete_tasks' =>  "Forgetting to complete tasks",
	'mental_disorders_gross_impairment_in_communication' =>  "Gross impairment in communication",
	'mental_disorders_gross_impairment_in_thought_processes' =>  "Gross impairment in thought processes",
	'mental_disorders_grossly_inappropriate_behavior' =>  "Gross impairment in thought processes",
	'mental_disorders_neglect_of_personal_appearance_and_hygiene' =>  "Neglect of personal appearance and hygiene",
	'mental_disorders_suspiciousness' =>  "Suspiciousness",
	'mental_disorders_total_occupational_and_social_impairment' =>  "Total occupational and social impairment",
	'mental_disorders_deficiencies_in_most_areas' =>  "Deficiencies in most areas, such as work, school, family relations, judgment, thinking, or mood",
	'mental_disorders__reduced_reliability_and_productivity' =>  "Reduced reliability and productivity",
	'mental_disorders_occasional_decrease_in_work_efficiency_and_intermittent_periods' =>  "Occasional decrease in work efficiency and intermittent periods of inability to perform occupational tasks",
	'mental_disorders_mild_or_transient_symptoms_which_decrease_work_efficiency' =>  "Mild or transient symptoms which decrease work efficiency and ability to perform occupational tasks only during periods of significant stress",
	'mental_disorders_symptoms_controlled_by_continuous_medication' =>  "Symptoms controlled by continuous medication",
	'mental_disorders_symptoms_are_not_severe_enough' =>  "Symptoms are not severe enough either to interfere with occupational and social functioning or to require continuous medication",
	'mental_disorders_chronic_sleep_impairment' =>  "Chronic sleep impairment",
	'mental_disorders_circumlocutory_speech' =>  "Circumlocutory speech",
	'mental_disorders_circumstantial_speech' =>  "Circumstantial speech",
	'mental_disorders_difficulty_in_adapting_to_a_worklike_setting' =>  "Difficulty in adapting to a worklike setting",
	'mental_disorders_difficulty_in_adapting_to_stressful_circumstances' =>  "Difficulty in adapting to stressful circumstances",
	'mental_disorders_difficulty_in_adapting_to_work' =>  "Difficulty in adapting to work",
	'mental_disorders_difficulty_in_establishing_and_maintaining_effective_work_and_social_relationships' =>  "Difficulty in establishing and maintaining effective work and social relationships",
	'mental_disorders_difficulty_in_understanding_complex_commands' =>  "Difficulty in understanding complex commands",
	'mental_disorders_disorientation_to_place' =>  "Disorientation to place",
	'mental_disorders_disorientation_to_time' =>  "Disorientation to time",
	'mental_disorders_disturbances_of_motivation_and_mood' =>  "Disturbances of motivation and mood",
	'mental_disorders_flattened_affect' =>  "Flattened affect",
        'mental_disorders_impaired_abstract_thinking' => "Impaired abstract thinking",
        'mental_disorders_impaired_impulse_control' => "Impaired impulse control",
        'mental_disorders_impaired_judgment' => "Impaired judgment",
        'mental_disorders_impairment_of_short_and_longterm_memory' => "Impairment of short- and long-term memory",
        'mental_disorders_inability_to_establish_and_maintain_effective_relationships' => "Inability to establish and maintain effective relationships",
        'mental_disorders_intermittent_inability_to_perform_activities_of_daily_living' => "Intermittent inability to perform activities of daily living",
        'mental_disorders_intermittent_inability_to_perform_maintenance_of_minimal_personal_hygiene' => "Intermittent inability to perform maintenance of minimal personal hygiene",
        'mental_disorders_memory_loss_for_names_of_close_relatives' => "Memory loss for names of close relatives",
        'mental_disorders_memory_loss_for_own_name' => "Memory loss for own name",
        'mental_disorders_memory_loss_for_own_occupation' => "Memory loss for own occupation",
        'mental_disorders_mental_condition_has_been_formally_diagnosed' => "Mental condition has been formally diagnosed",
        'mental_disorders_mild_memory_loss' => "Mild memory loss",
        'mental_disorders_near_continuous_depression' => "Near-continuous depression affecting the ability to function independently, appropriately and effectively",
        'mental_disorders_near_continuous_panic' => "Near-continuous panic affecting the ability to function independently, appropriately and effectively",
        'mental_disorders_obsessional_rituals_which_interfere_with_routine_activities' => "Obsessional rituals which interfere with routine activities",
        'mental_disorders_persistent_danger_of_hurting_others' => "Persistent danger of hurting others",
        'mental_disorders_persistent_danger_of_hurting_self' => "Persistent danger of hurting self",
        'mental_disorders_persistent_delusions' => "Persistent delusions",
        'mental_disorders_persistent_hallucinations' => "Persistent hallucinations",
        'mental_disorders_retention_of_only_highly_learned_material' => "Retention of only highly learned material",
        'mental_disorders_spatial_disorientation' => "Spatial disorientation",
        'mental_disorders_speech_intermittently_illogical' => "Speech intermittently illogical",
        'mental_disorders_speech_intermittently_irrelevant' => "Speech intermittently irrelevant",
        'mental_disorders_speech_intermittently_obscure' => "Speech intermittently obscure",
        'mental_disorders_stereotyped_speech' => "Stereotyped speech",
        'mental_disorders_suicidal_ideation' => "Suicidal ideation",
        'mental_disorders_unprovoked_irritability_with_periods_of_violence' => "Unprovoked irritability with periods of violence"
      }
    },

    {
      name: "Musculoskeletal System Knee Facts",         # Exam Response IEPD Usage Guide, v16.0, 3.2.14
      namespace: "kf",
      fact_block_tag_name: "kneeFacts",
      diagnosis_tag_name: "kneeDiagnoses",
      symptom_tag_name: "kneeSymptoms",
      document_title: "VA Disability Assessment Knee",
      additional_fields: {},
      diagnosis_info:
      {
        '5256' => { diagnosis_string: "Missing Knee Diagnoses in Usage Guide", modifiers: {} },
        '5257' => { diagnosis_string: "Missing Knee Diagnoses in Usage Guide", modifiers: {} },
        '5258' => { diagnosis_string: "Missing Knee Diagnoses in Usage Guide", modifiers: {} },
        '5259' => { diagnosis_string: "Missing Knee Diagnoses in Usage Guide", modifiers: {} },
        '5260' => { diagnosis_string: "Missing Knee Diagnoses in Usage Guide", modifiers: {} },
        '5261' => { diagnosis_string: "Missing Knee Diagnoses in Usage Guide", modifiers: {} },
        '5262' => { diagnosis_string: "Missing Knee Diagnoses in Usage Guide", modifiers: {} },
        '5263' => { diagnosis_string: "Missing Knee Diagnoses in Usage Guide", modifiers: {} },
      },
      symptom_info:
      {
        "laxity" => "Laxity shown, but without recurrent subluxation or instability",
        "painful_flexion" => "Painful Flexion",
        "painful_extension" => "Painful Extension",
        "patellar_subluxation" => "patellar subluxation"
      }
    },

    { 
      name: "Digestive Facts",         # Exam Response IEPD Usage Guide, v16.0, 3.2.15
      namespace: "digf",
      fact_block_tag_name: "digestiveFacts",
      diagnosis_tag_name: "digestiveDiagnoses",
      symptom_tag_name: "digestiveSymptoms",
      document_title: "VA Disability Assessment Digestive",
      additional_fields: {},
      diagnosis_info:
      {
        '7321' => { diagnosis_string: "Amebiasis", modifiers: {
                        'amebiasis_digestive_asymptomatic' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Asymptomatic" 
                          } },
                        'amebiasis_digestive_chronic_constipation_interrupted_by_diarrhea' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Chronic constipation interrupted by diarrhea"
                          } },
                        'amebiasis_digestive_gaseous_distention' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Gaseous distention"
                          } },
                        'amebiasis_digestive_lower_abdominal_cramps' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Lower abdominal cramps"
                          } },
                        'amebiasis_digestive_mild_gastrointestinal_disturbances' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Mild gastrointestinal disturbances"
                          } },
                        'amebiasis_digestive_nausea' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Nausea"
                          } }
        } },
        '7335' => { diagnosis_string: "Ano, fistula in", modifiers: {
                        'ano_fistula_digestive_complete_loss_of_sphincter_control' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Complete loss of sphincter control"
                          } },
                        'ano_fistula_digestive_constant_slight_leakage' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Constant slight leakage"
                          } },
                        'ano_fistula_digestive_extensive_leakage' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Extensive leakage"
                          } },
                        'ano_fistula_digestive_fairly_frequent_involuntary_bowel_movements' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Fairly frequent involuntary bowel movements"
                          } },
                        'ano_fistula_digestive_healed' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Healed"
                          } },
                        'ano_fistula_digestive_occasional_involuntary_bowel_movements' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Occasional involuntary bowel movements"
                          } },
                        'ano_fistula_digestive_occasional_moderate_leakage' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Occasional moderate leakage"
                          } },
                        'ano_fistula_digestive_slight_without_leakage' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Slight, without leakage"
                          } },
                        'ano_fistula_digestive_wearing_of_pad' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Wearing of pad"
                          } }
        } },
        '7344' => { diagnosis_string: "Benign neoplasms, exclusive of skin growths", modifiers: {
                        'malignant_neoplasms_digestive_evaluate_predominant_disability_or_specific_residuals' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Evaluate predominant disability or specific residuals"
                          } }
        } },
        '7316' => { diagnosis_string: "Cholangitis, chronic", modifiers: {
                        'cholangitis_chronic_digestive_attacks_of_gall_bladder_colic' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => {'Frequent attacks of gall bladder colic' => "Frequent attacks of gall bladder colic",
                                         'Infrequent attacks (not over two or three a year) of gall bladder colic' => "Infrequent attacks (not over two or three a year) of gall bladder colic"
                          } },
                        'cholangitis_chronic_digestive_gall_bladder_dyspepsia_confirmed_by_xray' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Gall bladder dyspepsia confirmed by X-ray"
                          } }
        } },
        '7314' => { diagnosis_string: "Cholecystitis, chronic", modifiers: {
                        'cholecystitis_chronic_digestive_attacks_of_gall_bladder_colic' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => {'Frequent attacks of gall bladder colic' => "Frequent attacks of gall bladder colic",
                                         'Infrequent attacks (not over two or three a year) of gall bladder colic' => "Infrequent attacks (not over two or three a year) of gall bladder colic"
                          } },
                        'cholecystitis_chronic_digestive_gall_bladder_dyspepsia_confirmed_by_xray' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Gall bladder dyspepsia confirmed by X-ray"
                          } }
        } },
        '7315' => { diagnosis_string: "Cholelithiasis, chronic", modifiers: {
                        'cholelithiasis_chronic_digestive_attacks_of_gall_bladder_colic' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => {'Frequent attacks of gall bladder colic' => "Frequent attacks of gall bladder colic",
                                         'Infrequent attacks (not over two or three a year) of gall bladder colic' => "Infrequent attacks (not over two or three a year) of gall bladder colic"
                          } },
                        'cholelithiasis_chronic_digestive_gall_bladder_dyspepsia_confirmed_by_xray' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Gall bladder dyspepsia confirmed by X-ray"
                          } }
        } },
        '7345' => { diagnosis_string: "Chronic liver disease without cirrhosis (including hepatitis B, chronic active hepatitis, autoimmune hepatitis, hemochromatosis, drug-induced hepatitis, etc., but excluding bile duct disorders and hepatitis C)", modifiers: {
                        'chronic_liver_disease_without_cirrhosis_digestive_continuous_medication' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => { '' => "Continuous medication"
                          } },
                        'chronic_liver_disease_without_cirrhosis_digestive_incapacitating_episodes' =>
                          { :fields  => ["digestiveSymptoms","value"],
                            :strings => {'Incapacitating episodes having a total duration of at least four weeks, but less than six weeks, during the past 12-month period' => "Incapacitating episodes having a total duration of at least four weeks, but less than six weeks, during the past 12-month period",
                                         'Incapacitating episodes having a total duration of at least two weeks, but less than four weeks, during the past 12-month period' => "Incapacitating episodes having a total duration of at least two weeks, but less than four weeks, during the past 12-month period",
                                         'Incapacitating episodes having a total duration of at least one week, but less than two weeks, during the past 12-month period' => "Incapacitating episodes having a total duration of at least one week, but less than two weeks, during the past 12-month period"
                          } }
} },
        '7312' => { diagnosis_string: "Cirrhosis of the liver, primary biliary cirrhosis, or cirrhotic phase of sclerosing cholangitis", modifiers: {} },
        '7323' => { diagnosis_string: "Colitis, ulcerative", modifiers: {} },
        '7322' => { diagnosis_string: "Dysentery, bacillary", modifiers: {} },
        '7324' => { diagnosis_string: "Distomiasis, intestinal or hepatic", modifiers: {} },
        '7327' => { diagnosis_string: "Diverticulitis", modifiers: {} },
        '7325' => { diagnosis_string: "Enteritis, chronic", modifiers: {} },
        '7326' => { diagnosis_string: "Enterocolitis, chronic", modifiers: {} },
        '7205' => { diagnosis_string: "Esophagus, diverticulum of, acquired", modifiers: {} },
        '7203' => { diagnosis_string: "Esophagus, stricture of", modifiers: {} },
        '7204' => { diagnosis_string: "Esophagus, spasm of (cardiospasm)", modifiers: {} },
        '7317' => { diagnosis_string: "Gall bladder, injury of", modifiers: {} },
        '7318' => { diagnosis_string: "Gall bladder, removal of", modifiers: {} },
        '7307' => { diagnosis_string: "Gastritis, hypertrophic (identified by gastroscope)", modifiers: {} },
#        'TBD' => { diagnosis_string: "Gastroesophageal reflux disease (GERD)", modifiers: {} },
        '7346' => { diagnosis_string: "Hernia hiatal", modifiers: {} },
        '7336' => { diagnosis_string: "Hemorrhoids, external or internal", modifiers: {} },
        '7354' => { diagnosis_string: "Hepatitis C (or non-A, non-B hepatitis)", modifiers: {} },
        '7340' => { diagnosis_string: "Hernia, femoral", modifiers: {} },
        '7338' => { diagnosis_string: "Hernia, inguinal", modifiers: {} },
        '7339' => { diagnosis_string: "Hernia, ventral, postoperative", modifiers: {} },
        '7330' => { diagnosis_string: "Intestine, fistula of, persistent, or after attempt at operative closure", modifiers: {} },
        '7329' => { diagnosis_string: "Intestine, large, resection of", modifiers: {} },
        '7328' => { diagnosis_string: "Intestine, small, resection of", modifiers: {} },
        '7319' => { diagnosis_string: "Irritable colon syndrome (spastic colitis, mucous colitis, etc.)", modifiers: {} },
        '7201' => { diagnosis_string: "Lips, injuries of", modifiers: {} },
#        'TBD' => { diagnosis_string: "Liver, injuries of", modifiers: {} },
        '7351' => { diagnosis_string: "Liver transplant", modifiers: {} },
        '7343' => { diagnosis_string: "Malignant neoplasms of the digestive system, exclusive of skin growths", modifiers: {} },
        '7200' => { diagnosis_string: "Mouth, injuries of", modifiers: {} },
        '7347' => { diagnosis_string: "Pancreatitis", modifiers: {} },
        '7301' => { diagnosis_string: "Peritoneum, adhesions of", modifiers: {} },
        '7308' => { diagnosis_string: "Postgastrectomy syndromes", modifiers: {} },
        '7337' => { diagnosis_string: "Pruritus ani", modifiers: {} },
        '7332' => { diagnosis_string: "Rectum and anus, impairment of sphincter control", modifiers: {} },
        '7333' => { diagnosis_string: "Rectum and anus, stricture of", modifiers: {} },
        '7334' => { diagnosis_string: "Rectum, prolapse of", modifiers: {} },
        '7310' => { diagnosis_string: "Stomach, injury of, residuals", modifiers: {} },
        '7309' => { diagnosis_string: "Stomach, stenosis of", modifiers: {} },
        '7305' => { diagnosis_string: "Ulcer, duodenal", modifiers: {} },
        '7304' => { diagnosis_string: "Ulcer, gastric", modifiers: {} },
        '7202' => { diagnosis_string: "Tongue, loss of whole or part", modifiers: {} },
        '7306' => { diagnosis_string: "Ulcer, marginal (gastrojejunal)", modifiers: {} },
        '7348' => { diagnosis_string: "Vagotomy with pyloroplasty or gastroenterostomy", modifiers: {} },
        '7342' => { diagnosis_string: "Visceroptosis, symptomatic, marked", modifiers: {} }
      },
      symptom_info:
      {
        'mild_symptoms' =>  "Mild Symptoms",
        'moderate_symptoms' =>  "Moderate Symptoms",
        'severe_symptoms' =>  "Severe Symptoms",
        'digestive_anorexia' => "Anorexia",
        'digestive_arthralgia' => "Arthralgia",
        'digestive_daily_fatigue' => "Daily fatigue",
        'digestive_dietary_restriction' => "Dietary restriction",
        'digestive_hepatomegaly' => "Hepatomegaly"
      }
    },

    { 
      name: "Gynecological Facts",         # Exam Response IEPD Usage Guide, v16.0, 3.2.16
      namespace: "gyf",
      fact_block_tag_name: "gynecologicalFacts",
      diagnosis_tag_name: "gynecologicalDiagnoses",
      symptom_tag_name: "gynecologicalSymptoms",
      document_title: "VA Disability Assessment Gynecological Disorders",
      additional_fields: {},
      diagnosis_info:
      {
		'7628' => { diagnosis_string: "Benign neoplasms of the gynecological system or breast", modifiers: {
                                'benign_neoplasms_of_the_gynecological_system_or_breast__malignant_neoplasm' =>
				  { :fields  => ["gynecologicalSymptoms","value"],
				    :strings => { 'Both'  => "Both",
				                  'Right' => "Right",
						  'Left'   => "Left"            
                                  } },
				'benign_neoplasms_of_the_gynecological_system_or_breast_benign_neoplasm' =>
				  { :fields  => ["gynecologicalSymptoms","value"],
				    :strings => { 'Both'  => "Both",
				                  'Right' => "Right",
						  'Left'   => "Left"            
                                  } }                                                                                                 
                } },
		'7626' => { diagnosis_string: "Breast surgery", modifiers: {} },
		'7612a' => { diagnosis_string: "Cervix disease", modifiers: {
                                'cervix_disease_or_injury_of_continuous_treatment' =>
				  { :fields  => ["gynecologicalSymptoms","value"],
				    :strings => { 'Symptoms that do not require continuous treatment'  => "Symptoms that do not require continuous treatment",
				                  'Symptoms that require continuous treatment' => "Symptoms that require continuous treatment",
						  'Symptoms not controlled by continuous treatment'   => "Symptoms not controlled by continuous treatment"            
                                  } }
                } },
		'7612b' => { diagnosis_string: "Cervix injury", modifiers: {} },                         #FIX_ME: Chip. Diagnoses modifiers
		'7629' => { diagnosis_string: "Endometriosis", modifiers: {
                                'endometriosis_heavy_bleeding' =>
                                  { :fields  => ["gynecologicalSymptoms","value"],
                                    :strings => { 'Heavy bleeding requiring continuous treatment for control'  => "Heavy bleeding requiring continuous treatment for control",
						  'Heavy bleeding not controlled by treatment' => "Heavy bleeding not controlled by treatment",
						  'Heavy bleeding not controlled by treatment and bowel symptoms'   => "Heavy bleeding not controlled by treatment and bowel symptoms",
						  'Heavy bleeding not controlled by treatment and bowel symptoms'   => "Heavy bleeding not controlled by treatment and bowel  symptoms"						               } },
                                'endometriosis_irregular_bleeding' =>
                                  { :fields  => ["gynecologicalSymptoms","value"],
                                    :strings => { 'Irregular bleeding requiring continuous treatment for control'  => "Irregular bleeding requiring continuous treatment for control",
						  'Irregular bleeding not controlled by treatment' => "Irregular bleeding not controlled by treatment",
						  'Irregular bleeding not controlled by treatment and bowel symptoms'   => "Irregular bleeding not controlled by treatment and bowel symptoms",
						  'Irregular bleeding not controlled by treatment and bladder symptoms'   => "Irregular bleeding not controlled by treatment and bladder symptoms" 
                                  } },
                                'endometriosis_pelvic_pain' =>
                                  { :fields  => ["gynecologicalSymptoms","value"],
                                    :strings => { 'Pelvic pain requiring continuous treatment for control'  => "Pelvic pain requiring continuous treatment for control",
                                                  'Pelvic pain not controlled by treatment and bowel symptoms'   => "Pelvic pain not controlled by treatment and bowel symptoms",
                                                  'Pelvic pain not controlled by treatment and bladder symptoms'   => "Pelvic pain not controlled by treatment and bladder symptoms" 
                                  } },
                                'endometriosis_lesions_involving' =>
                                  { :fields  => ["gynecologicalSymptoms","value"],
                                    :strings => { 'Lesions involving bladder confirmed by laparoscopy'  => "Lesions involving bladder confirmed by laparoscopy",
                                                  'Lesions involving bowel confirmed by laparoscopy'  => "Lesions involving bowel confirmed by laparoscopy"
                                  } }
                } },                          #FIX_ME: Chip. Diagnoses modifiers
		'7614a' => { diagnosis_string: "Fallopian tube adhesions", modifiers: {
                                 'fallopian_tube_disease_injury_or_adhesions_of_treatment' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Symptoms that do not require continuous treatment'  => "Symptoms that do not require continuous treatment",
                                                   'Symptoms that require continuous treatment'   => "Symptoms that require continuous treatment",
                                                   'Symptoms not controlled by continuous treatment'   => "Symptoms not controlled by continuous treatment" 
                                   } }
                } },		           #FIX_ME: Chip. Diagnoses modifiers
		'7614b' => { diagnosis_string: "Fallopian tube disease", modifiers: {
                                 'fallopian_tube_disease_injury_or_adhesions_of_treatment' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Symptoms that do not require continuous treatment'  => "Symptoms that do not require continuous treatment",
                                                   'Symptoms that require continuous treatment'   => "Symptoms that require continuous treatment",
                                                   'Symptoms not controlled by continuous treatment'   => "Symptoms not controlled by continuous treatment"
                                  } }
                } },		             #FIX_ME: Chip. Diagnoses modifiers
		'7614c' => { diagnosis_string: "Fallopian tube injury", modifiers: {
                                 'fallopian_tube_disease_injury_or_adhesions_of_treatment' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Symptoms that do not require continuous treatment'  => "Symptoms that do not require continuous treatment",
                                                   'Symptoms that require continuous treatment'   => "Symptoms that require continuous treatment",
                                                   'Symptoms not controlled by continuous treatment'   => "Symptoms not controlled by continuous treatment"
                                  } }
                } },		             #FIX_ME: Chip. Diagnoses modifiers
		#'TBD' => { diagnosis_string: "Female Sexual Arousal Disorder", modifiers: {} },
		'7624' => { diagnosis_string: "Fistula, rectovaginal", modifiers: {
                                 'fistula_rectovaginal_vaginal_fecal_leakage' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Vaginal fecal leakage less than once a week'  => "Vaginal fecal leakage less than once a week",
                                                   'Vaginal fecal leakage at least once a day requiring wearing of pad'   => "Vaginal fecal leakage at least once a day requiring wearing of pad",
                                                   'Vaginal fecal leakage one to three times per week requiring wearing of pad'   => "Vaginal fecal leakage one to three times per week requiring wearing of pad",
                                                   'Vaginal fecal leakage four or more times per week but less than daily requiring wearing of pad'   => "Vaginal fecal leakage four or more times per week but less than daily requiring wearing of pad",
                                                   'Without leakage' => "Without leakage"
                                   } },
                                 'fistula_rectovaginal_requiring_the_wearing_of_absorbent_materials_single_select' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Requiring the wearing of absorbent materials which must be changed less than two times per day'  => "Requiring the wearing of absorbent materials which must be changed less than two times per day",
                                                   'Requiring the wearing of absorbent materials which must be changed more than four times per day'   => "Requiring the wearing of absorbent materials which must be changed more than four times per day",
                                                   'Requiring the wearing of absorbent materials which must be changed two to four times per day'   => "Requiring the wearing of absorbent materials which must be changed two to four times per day"
                                   } }
                } },
		'7625' => { diagnosis_string: "Fistula, urethrovaginal", modifiers: {
                                 'fistula_urethrovaginal_multiple_urethrovaginal_fistulae' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { ''  => "Multiple urethrovaginal fistulae"
                                   } },
                                 'fistula_urethrovaginal_requiring_the_use_of_an_appliance' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { ''  => "Requiring the use of an appliance"
                                   } },
                                 'fistula_urethrovaginal_requiring_the_wearing_of_absorbent_materials_single_select' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Requiring the wearing of absorbent materials which must be changed less than two times per day'  => "Requiring the wearing of absorbent materials which must be changed less than two times per day",
                                                   'Requiring the wearing of absorbent materials which must be changed more than four times per day'   => "Requiring the wearing of absorbent materials which must be changed more than four times per day",
                                                   'Requiring the wearing of absorbent materials which must be changed two to four times per day'   => "Requiring the wearing of absorbent materials which must be changed two to four times per day"
                                   } }
                } },
		'7627' => { diagnosis_string: "Malignant neoplasms of the gynecological system or breast", modifiers: {} },
		#'TBD' => { diagnosis_string: "Pelvic Inflammatory Disease", modifiers: {} },
		'7623' => { diagnosis_string: "Surgical complications of pregnancy", modifiers: {
                                 'pregnancy_surgical_complications_of_surgical_complications_of_pregnancy_options' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => {'Surgical complications of pregnancy with relaxation of perineum'  => "Surgical complications of pregnancy with relaxation of perineum",
                                                  'Surgical complications of pregnancy with relaxation of perineum'  => "Surgical complications of pregnancy with relaxation of perineum",
                                                  'Surgical complications of pregnancy with relaxation of perineum'  => "Surgical complications of pregnancy with relaxation of perineum"
                                   } }
                } },
		#'TBD' => { diagnosis_string: "Ovaries and/or Uterus Conditions (including hysterectomy)", modifiers: {} },		#Diagnoses Modifer:  7613, 7615, 7617, 7618, 7619, 7619, 7621, 7622?
		'7611a' => { diagnosis_string: "Vagina disease", modifiers: {
                                 'vagina_disease_or_injury_of_continuous_treatment' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Symptoms that do not require continuous treatment'  => "Symptoms that do not require continuous treatment",
                                                   'Symptoms that require continuous treatment'   => "Symptoms that require continuous treatment",
                                                   'Symptoms not controlled by continuous treatment'   => "Symptoms not controlled by continuous treatment"
                                   } },
                                 'vagina_disease_or_injury_of_heavy_bleeding' =>
                                  { :fields  => ["gynecologicalSymptoms","value"],
                                    :strings => { 'Heavy bleeding requiring continuous treatment for control'  => "Heavy bleeding requiring continuous treatment for control",
                                                  'Heavy bleeding not controlled by treatment' => "Heavy bleeding not controlled by treatment",
                                                  'Heavy bleeding not controlled by treatment and bowel symptoms'   => "Heavy bleeding not controlled by treatment and bowel symptoms",
                                                  'Heavy bleeding not controlled by treatment and bowel symptoms'   => "Heavy bleeding not controlled by treatment and bowel  symptoms"                                                        } },
                                 'vagina_disease_or_injury_of_vaginal_fecal_leakage' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Vaginal fecal leakage less than once a week'  => "Vaginal fecal leakage less than once a week",
                                                   'Vaginal fecal leakage at least once a day requiring wearing of pad'   => "Vaginal fecal leakage at least once a day requiring wearing of pad",
                                                   'Vaginal fecal leakage one to three times per week requiring wearing of pad'   => "Vaginal fecal leakage one to three times per week requiring wearing of pad",
                                                   'Vaginal fecal leakage four or more times per week but less than daily requiring wearing of pad'   => "Vaginal fecal leakage four or more times per week but less than daily requiring wearing of pad",
                                                   'Without leakage' => "Without leakage"
                                   } },
                                 'vagina_disease_or_injury_of_injury_disease_condition' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Symptoms that do not require continuous treatment' => "Symptoms that do not require continuous treatment",
                                                   'Symptoms that require continuous treatment' => "Symptoms that require continuous treatment",
                                                   'Symptoms not controlled by continuous treatment' => "Symptoms not controlled by continuous treatment",
                                                   'No symptoms' => "No symptoms"
                                  } }
                } },
		'7611b' => { diagnosis_string: "Vagina injury", modifiers: {
                                 'vagina_disease_or_injury_of_continuous_treatment' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Symptoms that do not require continuous treatment'  => "Symptoms that do not require continuous treatment",
                                                   'Symptoms that require continuous treatment'   => "Symptoms that require continuous treatment",
                                                   'Symptoms not controlled by continuous treatment'   => "Symptoms not controlled by continuous treatment"
                                   } },
                                 'vagina_disease_or_injury_of_heavy_bleeding' =>
                                  { :fields  => ["gynecologicalSymptoms","value"],
                                    :strings => { 'Heavy bleeding requiring continuous treatment for control'  => "Heavy bleeding requiring continuous treatment for control",
                                                  'Heavy bleeding not controlled by treatment' => "Heavy bleeding not controlled by treatment",
                                                  'Heavy bleeding not controlled by treatment and bowel symptoms'   => "Heavy bleeding not controlled by treatment and bowel symptoms",
                                                  'Heavy bleeding not controlled by treatment and bowel symptoms'   => "Heavy bleeding not controlled by treatment and bowel  symptoms"                                                        } },
                                 'vagina_disease_or_injury_of_vaginal_fecal_leakage' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Vaginal fecal leakage less than once a week'  => "Vaginal fecal leakage less than once a week",
                                                   'Vaginal fecal leakage at least once a day requiring wearing of pad'   => "Vaginal fecal leakage at least once a day requiring wearing of pad",
                                                   'Vaginal fecal leakage one to three times per week requiring wearing of pad'   => "Vaginal fecal leakage one to three times per week requiring wearing of pad",
                                                   'Vaginal fecal leakage four or more times per week but less than daily requiring wearing of pad'   => "Vaginal fecal leakage four or more times per week but less than daily requiring wearing of pad",
                                                   'Without leakage' => "Without leakage"
                                   } },
                                 'vagina_disease_or_injury_of_injury_disease_condition' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Symptoms that do not require continuous treatment' => "Symptoms that do not require continuous treatment",
                                                   'Symptoms that require continuous treatment' => "Symptoms that require continuous treatment",
                                                   'Symptoms not controlled by continuous treatment' => "Symptoms not controlled by continuous treatment",
                                                   'No symptoms' => "No symptoms"
                                  } }
} },
		'7610a' => { diagnosis_string: "Vulva disease", modifiers: {
                                 'vulva_disease_or_injury_of_continuous_treatment' =>
                                   { :fields  => ["gynecologicalSymptoms","value"],
                                     :strings => { 'Symptoms that do not require continuous treatment'  => "Symptoms that do not require continuous treatment",
                                                   'Symptoms that require continuous treatment'   => "Symptoms that require continuous treatment",
                                                   'Symptoms not controlled by continuous treatment'   => "Symptoms not controlled by continuous treatment"
                                   } }
} },                        #FIX_ME: Chip. Diagnoses modifiers
		'7610b' => { diagnosis_string: "Vulva injury", modifiers: {} },                         #FIX_ME: Chip. Diagnoses modifiers  
		'7610c' => { diagnosis_string: "Vulvovaginitis", modifiers: {} }		                    #FIX_ME: Chip. Diagnoses modifiers
      },
      symptom_info:
      {
      }
    },


    { 
      name: "Musculoskeletal System Ankle",         # Exam Response IEPD Usage Guide, v16.0, 3.2.17
      namespace: "ankf",                            # ExamResponse-4.0.xsd
      fact_block_tag_name: "ankleFacts",            # ExamResponse-4.0.xsd
      diagnosis_tag_name: "ankleDiagnoses",         # AnkleFacts-1.2.xsd
      symptom_tag_name: "ankleSymptoms",            # AnkleFacts-1.2.xsd
      document_title: "VA Disability Assessment Ankle",
      additional_fields: {},
      diagnosis_info:
      {
        # We also need to deal with Acute SubAcute or Chronic diseases such as Arthritis, Gout, Bursitis, etc that map to the Ankle
        '5270' => { diagnosis_string: "Missing Ankle Diagnoses in Usage Guide", modifiers: {} },
        '5271' => { diagnosis_string: "Missing Ankle Diagnoses in Usage Guide", modifiers: {} },
        '5272' => { diagnosis_string: "Missing Ankle Diagnoses in Usage Guide", modifiers: {} },
        '5273' => { diagnosis_string: "Missing Ankle Diagnoses in Usage Guide", modifiers: {} },
        '5274' => { diagnosis_string: "Missing Ankle Diagnoses in Usage Guide", modifiers: {} }
      },
      symptom_info:
      {
      }
    },

    {
      name: "Scars (Head, Face, or Neck)",                     # Exam Response IEPD Usage Guide, v16.0, 3.2.18
      namespace: "hfnsfl",                                     # ExamResponse-4.0.xsd
      fact_block_tag_name: "headFaceNeckScarFactsList",        # ExamResponse-4.0.xsd
      diagnosis_tag_name: "Does not exist in schema",
      symptom_tag_name: "Does not exist in schema",
      document_title: "VA Disability Assessment Scars",
      additional_fields: {},
      diagnosis_info:
      {
      },
      symptom_info:
      {
      }
    },
    
    {
      name: "Musculoskeletal System Foot",              # Exam Response IEPD Usage Guide, v16.0, 3.2.19
      namespace: "cbsf",									              # CommonBodySystemFacts-2.0.xsd
      fact_block_tag_name: "commonBodySystemFacts",			# CommonBodySystemFacts-2.0.xsd
      diagnosis_tag_name: "diagnoses",						      # CommonBodySystemFacts-2.0.xsd
      symptom_tag_name: "symptoms",							        # CommonBodySystemFacts-2.0.xsd
      document_title: "VA Disability Assessment Foot",
      additional_fields: {"commonType" => "Foot"},      # needed because it is using the commonBodySystemFacts block
      diagnosis_info:
      {
        '5278a' => { diagnosis_string: "Claw foot, acquired", modifiers: {} },          #FIX_ME: Chip. This needs a diagnoses modifier
		    '5278b' => { diagnosis_string: "Pes Cavus, acquired", modifiers: {} },
		    '5276' => { diagnosis_string: "Flatfoot, acquired", modifiers: {} },
		   #'TBD' => { diagnosis_string: "Pes Planus", modifiers: {} },                    #FIX_ME: Chip, code doesn't exist in the spreadsheet - Make one up
		   #'TBD' => { diagnosis_string: "Plantar Fasciitis", modifiers: {} },             #FIX_ME: Chip, code doesn't exist in the spreadsheet - Make one up
		    '5284' => { diagnosis_string: "Foot injuries, other", modifiers: {} },
		    '5283' => { diagnosis_string: "Tarsal, or metatarsal bones, malunion of, or nonunion of", modifiers: {} },
		    '5281' => { diagnosis_string: "Hallux rigidus, unilateral, severe", modifiers: {} },
		    '5280' => { diagnosis_string: "Hallux valgus, unilateral", modifiers: {} },
		    '5282' => { diagnosis_string: "Hammer toe", modifiers: {} },
		    '5279' => { diagnosis_string: "Metatarsalgia", modifiers: {} },
		   #'TBD' => { diagnosis_string: "Morton's Disease", modifiers: {} },              #FIX_ME: Chip, code doesn't exist in the spreadsheet
        '5277' => { diagnosis_string: "Weak Foot", modifiers: { 'bilateral_unilateral'  => { fields: [ 'symptoms', 'value' ], strings: {'Bilateral' => "Bilateral", 'Unilateral' => "Unilateral"} },
                                                                'TBD'                   => { fields: [ 'symptoms', 'value' ], strings: {'Bilateral' => "Bilateral", 'Unilateral' => "Unilateral"} }   } }
      },
      symptom_info:
      {
      }
    },

    {
      name: "Musculoskeletal System Elbow",                  # Exam Response IEPD Usage Guide, v16.0, 3.2.20
      namespace: "elbf",                                     # ExamResponse-4.0.xsd
      fact_block_tag_name: "elbowFacts",                     # ExamResponse-4.0.xsd
      diagnosis_tag_name: "elbowDiagnoses",                  # ElbowFacts-1.3.xsd
      symptom_tag_name: "elbowSymptoms",                     # ElbowFacts-1.3.xsd
      document_title: "VA Disability Assessment Elbow",
      additional_fields: {},
      diagnosis_info:
      {
        '5205' => { diagnosis_string: "Missing Elbow Diagnoses in Usage Guide", modifiers: {} },
        '5206' => { diagnosis_string: "Missing Elbow Diagnoses in Usage Guide", modifiers: {} },
        '5207' => { diagnosis_string: "Missing Elbow Diagnoses in Usage Guide", modifiers: {} },
        '5208' => { diagnosis_string: "Missing Elbow Diagnoses in Usage Guide", modifiers: {} },
        '5209' => { diagnosis_string: "Missing Elbow Diagnoses in Usage Guide", modifiers: {} },
        '5210' => { diagnosis_string: "Missing Elbow Diagnoses in Usage Guide", modifiers: {} },
        '5211' => { diagnosis_string: "Missing Elbow Diagnoses in Usage Guide", modifiers: {} },
        '5212' => { diagnosis_string: "Missing Elbow Diagnoses in Usage Guide", modifiers: {} },
        '5213' => { diagnosis_string: "Missing Elbow Diagnoses in Usage Guide", modifiers: {} }
      },
      symptom_info:
      {
      }
    },

    {
      name: "Musculoskeletal System Hip",         # Exam Response IEPD Usage Guide, v16.0, 3.2.21
      namespace: "hif",
      fact_block_tag_name: "hipFacts",
      diagnosis_tag_name: "hipDiagnoses",
      symptom_tag_name: "hipDiagnoses",
      document_title: "VA Disability Assessment Hip",
      additional_fields: {},
      diagnosis_info:
      {
		    '5250' => { diagnosis_string: "Ankylosis", modifiers: {} },
		    '5255' => { diagnosis_string: "Femur", modifiers: {} },
		    '5254' => { diagnosis_string: "Flail joint of the hip", modifiers: {} }
      },
      symptom_info:
      {
      }
    },

    {
      name: "Musculoskeletal System Osteomyelitis",         # Exam Response IEPD Usage Guide, v16.0, 3.2.22
      namespace: "cbsf",									                  # ExamResponse-4.0.xsd
      fact_block_tag_name: "commonBodySystemFacts",			    # ExamResponse-4.0.xsd
      diagnosis_tag_name: "diagnoses",						          # CommonBodySystemFacts-2.0.xsd
      symptom_tag_name: "symptoms",							            # CommonBodySystemFacts-2.0.xsd
      document_title: "VA Disability Assessment Osteomyelitis",
      additional_fields: {"commonType" => "Osteomyelitis"},                         # needed because it is using the commonBodySystemFacts block
      diagnosis_info:
      {
        '5000' => { diagnosis_string: "Osteomyelitis", modifiers: {} }
      },
      symptom_info:
      {
      }
    },

    {
      name: "Musculoskeletal System Others",         # Exam Response IEPD Usage Guide, v16.0, 3.2.23
      namespace: "msof",
      fact_block_tag_name: "musculoskeletalOtherFacts",
      diagnosis_tag_name: "musculoskeletalOtherDiagnoses",
      symptom_tag_name: "musculoskeletalOtherSymptoms",
      document_title: "VA Disability Assessment Musculoskeletal Other Disorders",
      additional_fields: {},
      diagnosis_info:
      {
		    '5012' => { diagnosis_string: "Bones, new growths of, malignant", modifiers: {} },
		    '5275' => { diagnosis_string: "Bones, of the lower extremity, shortening of", modifiers: {} },
		    '5298' => { diagnosis_string: "Coccyx, removal of", modifiers: {} },
		    '5025' => { diagnosis_string: "Fibromyalgia", modifiers: {} },
		    '5297' => { diagnosis_string: "Ribs, removal of", modifiers: {} },
		    '5296' => { diagnosis_string: "Skull, loss of part of, both inner and outer tables", modifiers: {} }
		   #'TBD' => { diagnosis_string: "Shin Splints", modifiers: {} }

      },
      symptom_info:
      {
      }
    },

    {
      name: "Musculoskeletal System Shoulder",         # Exam Response IEPD Usage Guide, v16.0, 3.2.24
      namespace: "shf",
      fact_block_tag_name: "shoulderFacts",
      diagnosis_tag_name: "shoulderDiagnoses",
      symptom_tag_name: "shoulderSymptoms",
      document_title: "VA Disability Assessment Shoulder",
      additional_fields: {},
      diagnosis_info:
      {
        '5200' => { diagnosis_string: "Missing Shoulder Diagnoses in Usage Guide", modifiers: {} },
        '5203' => { diagnosis_string: "Missing Shoulder Diagnoses in Usage Guide", modifiers: {} }
      },
      symptom_info:
      {
      }
    },

    {
      name: "Musculoskeletal System Toe Amputations",         # Exam Response IEPD Usage Guide, v16.0, 3.2.25
      namespace: "cbsf",									                    # ExamResponse-4.0.xsd
      fact_block_tag_name: "commonBodySystemFacts",			      # ExamResponse-4.0.xsd
      diagnosis_tag_name: "diagnoses",						            # CommonBodySystemFacts-2.0.xsd
      symptom_tag_name: "symptoms",							              # CommonBodySystemFacts-2.0.xsd
      document_title: "VA Disability Assessment Toes",
      additional_fields: {"commonType" => "Toes"},            # needed because it is using the commonBodySystemFacts block
      diagnosis_info:
      {
		    '5170' => { diagnosis_string: "Toe Amputations", modifiers: {} },    # We need additional fields or diagnoses modifiers to match the Usage Guide
		    '5171' => { diagnosis_string: "Toe Amputations", modifiers: {} },    # We need additional fields or diagnoses modifiers to match the Usage Guide
		    '5172' => { diagnosis_string: "Toe Amputations", modifiers: {} },    # We need additional fields or diagnoses modifiers to match the Usage Guide
		    '5173' => { diagnosis_string: "Toe Amputations", modifiers: {} },    # We need additional fields or diagnoses modifiers to match the Usage Guide
      },
      symptom_info:
      {
      }
    },

    {
      name: "Musculoskeletal System Wrist",         # Exam Response IEPD Usage Guide, v16.0, 3.2.26
      namespace: "wf",
      fact_block_tag_name: "wristFacts",
      diagnosis_tag_name: "wristDiagnoses",
      symptom_tag_name: "wristSymptoms",
      document_title: "VA Disability Assessment Wrist",
      additional_fields: {},
      diagnosis_info:
      {
        '5214' => { diagnosis_string: "Missing Wrist Diagnoses in Usage Guide", modifiers: {} },
        '5215' => { diagnosis_string: "Missing Wrist Diagnoses in Usage Guide", modifiers: {} }
      },
      symptom_info:
      {
      }
    },

    {
      name: "Musculoskeletal System Amputations",         # Exam Response IEPD Usage Guide, v16.0, 3.2.27 (DO THIS NOW)
      namespace: "TBD",
      fact_block_tag_name: "TBD",
      diagnosis_tag_name: "TBD",
      symptom_tag_name: "TBD",
      document_title: "VA Disability Assessment Amputations",
      additional_fields: {},
      diagnosis_info:
      {
      },
      symptom_info:
      {
      }
    },

    {
      name: "Scars Extremities and Trunk Facts",                                  # Exam Response IEPD Usage Guide, v16.0, 3.2.28
      namespace: "setfl",                                                         # ExamResponse-4.0.xsd
      fact_block_tag_name: "scarExtremitiesTrunkFactsList",                       # ExamResponse-4.0.xsd, ScarExtremitesTrunkFactsList-1.2.xsd
      diagnosis_tag_name: "Does not exist in schema",
      symptom_tag_name: "Does not exist in schema",
      document_title: "VA Disability Assessment Scars (Extremities and Trunk)",
      additional_fields: {},
      diagnosis_info:
      {
      },
      symptom_info:
      {
      }
    },

    {
      name: "Organs of Special Sense (Vision) Facts",         # Exam Response IEPD Usage Guide, v16.0, 3.2.29
      namespace: "eyef",
      fact_block_tag_name: "eyeFacts",   # ExamResponse-4.0.xsd, EyeFacts-1.1.xsd, Eye-1.1.xsd
      diagnosis_tag_name: "eyeDiagnoses",
      symptom_tag_name: "eyeSymptoms",
      document_title: "VA Disability Assessment Eye",
      additional_fields: {},
      diagnosis_info:
      {
        "6012" => "Angle-closure glaucoma",
        "6029" => "Aphakia or dislocation of crystalline lens",
        "6015" => "Benign neoplasms (of eyeball and adnexa)",
        "6027" => "Cataract of any type",
#              "TBD" => "Choroiditis",   Must be handled with a diagnosis modifier
        "6000" => "Choroidopathy",
        "6018" => "Chronic conjunctivitis (nontrachomatous)",
#              "TBD" => "Cyclitis",   Must be handled with a diagnosis modifier
        "6008" => "Detachment of retina",
        "6090" => "Diplopia",
        "6025" => "Disorders of the lacrimal apparatus (epiphora, dacryocystitis, etc.)",
#NOT IN ECFR              "TBD" => "Dry eye syndrome",
        "6020" => "Ectropion",
        "6021" => "Entropion",
        "6007" => "Intraocular hemorrhage",
#              "TBD" => "Iritis",   Must be handled with a diagnosis modifier
        "6035" => "Keratoconus",
        "6001" => "Keratopathy",
        "6022" => "Lagophthalmos",
        "6023" => "Loss of eyebrows",
        "6024" => "Loss of eyelashes",
        "6032" => "Loss of eyelids, partial or complete",
        "6014" => "Malignant neoplasms (eyeball only)",
        "6016" => "Nystagmus, central",
        "6013" => "Open-angle glaucoma",
        "6026" => "Optic neuropathy",
        "6030" => "Paralysis of accommodation (due to neuropathy of the Oculomotor Nerve (cranial nerve III))",
        "6037" => "Pinguecula",
        "6034" => "Pterygium",
        "6019" => "Ptosis, unilateral or bilateral",
        "6011" => "Retinal scars, atrophy, or irregularities",
        "6006" => "Retinopathy or maculopathy",
        "6002" => "Scleritis",
        "6081" => "Scotoma, unilateral",
        "6036" => "Status post corneal transplant",
        "6091" => "Symblepharon",
        "6017" => "Trachomatous conjunctivitis",
#NOT IN ECFR              "TBD" => "Unhealed eye injury",
#              "TBD" => "Uveitis",   Must be handled with a diagnosis modifier
        "6080" => "Visual Impairment"
      },
      symptom_info:
      {
      }
    }
  ]


VbmsRFactGroup.destroy_all
THE_SET_OF_VBMS_R_FACT_GROUP_VALUES.each do |the_fact_group_info|
  VbmsRFactGroup.create(the_fact_group_info)
end  