class AddSoftDeleteColumnsToLookupTables < ActiveRecord::Migration

  CSV_TABLE_NAMES = [
    :care_categories,
    :consultation_orders,
    :consultation_statuses,
    :consultation_types,
    :medical_specialties,
    :other_health_insurances,
    :referral_document_types,
    :referral_reasons,
    :referral_types,
    :visns,
    :sites,
    :diagnosis_codes
  ]

  def change
    AddSoftDeleteColumnsToLookupTables::CSV_TABLE_NAMES.each do |csv_table_name|
      add_column csv_table_name, :deleted_at, :datetime
    end
  end
end
