class CreateReferrals < ActiveRecord::Migration
  def change
    create_table :referrals do |t|
      t.integer :coordinator_id,        null: false
      t.string  :referral_number,       null: false
      t.string  :authorization_number,  null: false
      t.json    :content
      t.timestamps null: false
    end

    add_reference   :referrals, :consultation,            foreign_key: true
    add_reference   :referrals, :referral_status,         foreign_key: true
    add_reference   :referrals, :referral_type,           foreign_key: true
    add_reference   :referrals, :referral_reason,         foreign_key: true
    add_reference   :referrals, :provider,                foreign_key: true

    add_index       :referrals, :authorization_number,    unique: true
    add_index       :referrals, :referral_number,         unique: true

    add_index       :referrals, :provider_id
    add_index       :referrals, :coordinator_id
    add_index       :referrals, :consultation_id
    add_index       :referrals, :referral_status_id
    add_index       :referrals, :referral_type_id
    add_index       :referrals, :referral_reason_id

  end
end
