class CreateConsultations < ActiveRecord::Migration
  def change
    create_table :consultations do |t|
      t.string :consultation_number, null: false
      t.integer :ordering_provider_id  # consultation ->  non-VHA provider (null if VHA)
      t.datetime :valid_from
      t.datetime :valid_to
      t.json :content
      t.timestamps null: false
    end
    add_reference   :consultations, :care_category,       foreign_key: true
    add_reference   :consultations, :consultation_order,  foreign_key: true
    add_reference   :consultations, :consultation_status, foreign_key: true
    add_reference   :consultations, :consultation_type,   foreign_key: true
    add_reference   :consultations, :veteran,             foreign_key: true

    add_index       :consultations, :care_category_id
    add_index       :consultations, :consultation_number,     unique: true
    add_index       :consultations, :consultation_order_id
    add_index       :consultations, :consultation_status_id
    add_index       :consultations, :consultation_type_id
    add_index       :consultations, :ordering_provider_id
    add_index       :consultations, :veteran_id
  end
end
