class CreateProviders < ActiveRecord::Migration
  def change
    create_table :providers do |t|
      t.string :npi, null: false
      t.string :name, null: false
      t.string :physician_name, null: false
      t.json :content

      t.timestamps null: false
    end

    add_index :providers, :npi,    unique: true
    add_index :providers, :name

    add_reference :providers, :facility, foreign_key:true
    add_index     :providers, :facility_id

  end
end
