class AddUserToEvaluation < ActiveRecord::Migration
  def up
    add_column :evaluations, :user_id, :integer
    add_column :evaluations, :assigner_id, :integer

    # now set the user_id for each evaluation to the correct value before we
    # trash the contention ids
    Evaluation.all.each do |evaluation|
      # Get users for all the evaluation's contentions
      users = evaluation.contentions.map{ |c| c.user_id }
      assigners = evaluation.contentions.map{ |c| c.assigner_id }

      # if there's more than one owner of a parent contention, we don't know
      # which to pick as the evaluation owner
      #
      # commenting out as per conversation with Greg
      #if users.uniq.length > 1
      #  throw "Unable to set user for evaluation #{evaluation.id}."
      #end

      if users.length == 0
        throw "somehow there are no users for evaluation #{evaluation.id}?"
      end

      # commenting out as per conversation with Greg
      #if assigners.uniq.length > 1
      #  throw "Unable to set assigner for evaluation #{evaluation.id}."
      #end

      if assigners.length == 0
        throw "somehow there are no assigners for evaluation #{evaluation.id}."
      end

      evaluation.user_id = users[0]
      evaluation.assigner_id = assigners[0]
      evaluation.save
    end

    remove_column :contentions, :user_id
  end

  def down
    add_column :contentions, :user_id, :integer

    Evaluation.all.each do |evaluation|
      evaluation.contentions.each do |contention|
        contention.user_id = evaluation.user_id
        contention.save
      end
    end

    remove_column :evaluations, :user_id
    remove_column :evaluations, :assigner_id
  end
end
