class AddExaminerRoleToUsers < ActiveRecord::Migration
  def up
    User.all.each do |u|
      # The lack of roles used to define an examiner; add the "examiner" role
      # to a user if they have no roles
      if u.roles.length == 0
        u.roles << "examiner"
        u.save
      end
    end
  end

  # it doesn't hurt anything to have examiner roles for users, so don't remove
  # them on down
end
