# config/initializers/pointless_feedback.rb
# TODO: replace pointless_feedback gem with inherent capability

if ENABLE_FEEDBACK
  ###############################################################
  ## Configure the pointless_feedback gem
  ## TODO: Remove this gem replacing its functionality with inherent
  ##       capability

  PointlessFeedback.setup do |config|
    # Configure the topics for the user to choose from on the feedback form
    config.message_topics = [
      'Bug, Error Or Defect',
      'Comment',
      'Enhancement / Suggested Improvement',
      'Question?',
      'Technical Support'
    ]
    config.email_feedback = false # NOTE: disable the gem's eMail system in favor of our own

  end # PointlessFeedback.setup do |config|

  # Use the same gateway for both hipchat and slack notifications
  if ENABLE_FEEDBACK_HIPCHAT  ||  ENABLE_FEEDBACK_SLACK
    # Using hipchat/slack via a dRuby gateway
    # NOTE: forced to go outside of Rails due to persistent openSSL
    #       error generated by the 'hipchat' gem dependencies as a result
    #       of Rails v4.2.3 security problems.

    if ENV['FEEDBACK_IM_GATEWAY'].present?
      require 'drb/drb'
      DRb.start_service
      ImGateway = DRbObject.new_with_uri(ENV['FEEDBACK_IM_GATEWAY'])
    else
      logger.error("Hipchat/slack notification of feedback was requested; but FEEDBACK_IM_GATEWAY was not defined.")
      ENABLE_FEEDBACK_HIPCHAT = false
      ENABLE_FEEDBACK_SLACK   = false
    end

  end # if ENABLE_FEEDBACK_HIPCHAT
else
  ENABLE_FEEDBACK_HIPCHAT = false
  ENABLE_FEEDBACK_SLACK   = false
  ENABLE_FEEDBACK_EMAIL   = false
end # if ENABLE_FEEDBACK
