require 'byebug'
require 'uri'

APP_URL         = ENV['APP_URL']
uri             = URI(APP_URL)
HOST            = uri.host
PORT            = uri.port
HOST_WITH_PORT  = HOST.to_s + (PORT ? ":#{PORT}" : '')

DrTurboTax::Application.configure do

  # Settings specified here will take precedence over those in config/application.rb.

  # In the development environment your application's code is reloaded on
  # every request. This slows down response time but is perfect for development
  # since you don't have to restart the web server when you make code changes.
  config.cache_classes = false

  # Do not eager load code on boot.
  config.eager_load = false

  config.action_controller.default_url_options = { host: HOST_WITH_PORT }

  # Show full error reports and disable caching.
  config.consider_all_requests_local       = true
  config.action_controller.perform_caching = false

  ##############################################################
  # ActionMailer Configuration

  # config.action_mailer.preview_path = "#{Rails.root}/spec/mailers/previews"

  config.action_mailer.raise_delivery_errors = true

  config.action_mailer.delivery_method = :smtp

  config.action_mailer.default_url_options = { host: HOST_WITH_PORT }

  config.action_mailer.smtp_settings = {
    address:              ENV['EMAIL_HOST'],
    port:                 ENV['EMAIL_PORT'],
    domain:               ENV['EMAIL_DOMAIN'],
    user_name:            ENV['EMAIL_USER'],
    password:             ENV['EMAIL_PASS'],
    authentication:       'plain',
    enable_starttls_auto: true
  }

  ##############################################################

  # Print deprecation notices to the Rails logger.
  config.active_support.deprecation = :log

  # Raise an error on page load if there are pending migrations
  config.active_record.migration_error = :page_load

  # Debug mode disables concatenation and preprocessing of assets.
  # This option may cause significant delays in view rendering with a large
  # number of complex assets.
  # (Not using truth_or_consequences boolean ENV format because this module gets
  # loaded before aarp.rb.)
  config.assets.debug = ENV['ALWAYS_MINIFY_ASSETS'].to_s.upcase != 'TRUE'

  # The location of the Haml FML form templates
  config.form_views = File.join(File.dirname(__FILE__), "..", "..", "app", "views", "forms")

  # Use qunit-rails to set up a path for the qunit tests. Will be available at /qunit
  config.qunit.tests_path = "spec"


  config.after_initialize do
    Bullet.enable = true
    Bullet.alert = false
    Bullet.bullet_logger = true
    Bullet.console = true
    Bullet.growl = false
    Bullet.rails_logger = true
    Bullet.add_footer = false
   end

end
