# Set up gems listed in the Gemfile.
ENV['BUNDLE_GEMFILE'] ||= File.expand_path('../../Gemfile', __FILE__)

require 'bundler/setup' if File.exists?(ENV['BUNDLE_GEMFILE'])

require 'rails/commands/server'

# Set rails server to default to specified Host and Port (rather than localhost:3000)
# Useful when using 'rails s Puma' to start the Puma server.
module DefaultOptions
  def default_options
    super.merge!(Host: ENV['PUMA_HOST'], Port: ENV['PUMA_PORT'])
  end
end

Rails::Server.send(:prepend, DefaultOptions)