require File.expand_path('../boot', __FILE__)
require 'csv'
# Pick the frameworks you want:
require "active_record/railtie"
require "action_controller/railtie"
require "action_mailer/railtie"     # TODO: consider replacing action_mailer with 'mail' gem
require "sprockets/railtie"

# require "rails/test_unit/railtie"

require 'csv'
require 'rails/all'

require 'awesome_print'

ENV['RACK_ENV']     = 'development'   unless ENV.has_key?('RACK_ENV')
ENV['RAILS_ENV']    = 'development'   unless ENV.has_key?('RAILS_ENV')
ENV['DEPLOY_TYPE']  = 'localhost'     unless ENV.has_key?('DEPLOY_TYPE')


# Require the gems listed in Gemfile, including any gems
# you've limited to :test, :development, or :production.
Bundler.require(:default, Rails.env)




# SNELL: Bug? in Rails v4.2.3 Rails.root and RAILS_ROOT are not defined at this point
#        in the startup process.
RAILS_ROOT = Pathname.new(__FILE__).parent.parent unless defined?(RAILS_ROOT)


# Load the .env* files in the opposite order as bin/setup_environment.
# dotenv sets and maintains the value of a variable the FIRST time it is assigned.  This allows the
# use of existing shell values to over-ride any value specified in a .env* file.
# NOTE: ignoring the railtie

Dotenv.load(  # If a file does not exist, dotenv will ignore it in the load() method
              RAILS_ROOT + ".env.#{ENV['DEPLOY_TYPE']}.local",
              RAILS_ROOT + ".env.#{ENV['RAILS_ENV']}.local",
              RAILS_ROOT + ".env.local",
              RAILS_ROOT + ".env.#{ENV['DEPLOY_TYPE']}",
              RAILS_ROOT + ".env.#{ENV['RAILS_ENV']}",
              RAILS_ROOT + ".env"
)


module DrTurboTax
  class Application < Rails::Application
    # Settings in config/environments/* take precedence over those specified here.
    # Application configuration should go into files in config/initializers
    # -- all .rb files in that directory are automatically loaded.

    # Set Time.zone default to the specified zone and make Active Record auto-convert to this zone.
    # Run "rake -D time" for a list of tasks for finding time zone names. Default is UTC.
    # config.time_zone = 'Central Time (US & Canada)'

    # The default locale is :en and all translations from config/locales/*.rb,yml are auto loaded.
    # config.i18n.load_path += Dir[Rails.root.join('my', 'locales', '*.{rb,yml}').to_s]
    # config.i18n.default_locale = :de
    config.i18n.enforce_available_locales = true
    config.active_record.schema_format = :ruby
    config.active_record.raise_in_transactional_callbacks = true
    config.autoload_paths << Rails.root.join('lib')
    # config.active_record.whitelist_attributes = true
    config.autoload_paths << Rails.root.join('lib')
    config.assets.enabled = false

  end
end
