module VX_API
  class PatientSearch

    # Individual veteran's record from the web service
    class Veteran < EnhancedHash

      # access by:            API uses:
      property :first_name,   from: 'givenNames'  #=> "givenNames"=>"PATIENT"
      property :last_name,    from: 'familyName'  #=> "EIGHT"
      property :gender_code,  from: 'genderCode'  #=> "M"
      property :ssn,          from: 'ssn'         #=> "*****0008"

      property :birth_date,   from: 'birthDate',  #=> "19350407" - YYYYMMDD
                                with: ->(value) { Date.strptime(value,"%Y%m%d") }

      property :addresses,    from: 'address',    #=> an Array of Hash [{"city"=>"ANY TOWN", "line1"=>"ANY STREET", "state"=>"WV", "use"=>"H", "zip"=>"99998-0071"}]
                                coerce: Array[Veteran::Address]

      property :phones,       from: 'telecom',    #=> an Array of Hash [{"use"=>"H", "value"=>"222-555-7720"}]
                                coerce: Array[Veteran::Phone]

      property :id,           from: 'id'          #=> "10108V420871^NI^200M^USVHA^P"
      property :facility,     from: 'facility'    #=> "200M"
      property :data_source,  from: 'dataSource'  #=> "USVHA"
      property :patient_id,   from: 'pid'         #=> "10108V420871"
      property :id_type,      from: 'idType'      #=> "NI"
      property :id_class,     from: 'idClass'     #=> "ICN"
      property :full_name,    from: 'fullName'    #=> "EIGHT,PATIENT"
      property :display_name, from: 'displayName' #=> "EIGHT,PATIENT"
      property :age,          from: 'age'         #=> 81
      property :gender_name,  from: 'genderName'  #=> "Male"
      property :sensitive,    from: 'sensitive'   #=> false

    end # class Veteran < EnhancedHash
  end # class PatientSearch
end # module VX_API

