module VIA_API
  class Veteran
    class << self

      def mpi_lookup
        # FindPatientService

        response  = FINDPATIENT_CLIENT.call(:mpi_lookup, message: mpi_lookup_request)

        return response.body
      end # def mpi_lookup
      alias_method :search, :mpi_lookup

      def mpi_lookup_request
        login_via_request = VIA_API.login_via_request
        login_via_response = FINDPATIENT_CLIENT.call(:login_v_i_a, message: login_via_request).body

        duz           = login_via_response[:login_via_response][:user_to][:duz]
        user_name     = login_via_response[:login_via_response][:user_to][:name]
        site_id       = login_via_response[:login_via_response][:user_to][:site_id]

        request = {}
        request[:queryBean]= {
         provider:{
          userId: duz,
          name: user_name,
          loginSiteCode: site_id
         },
         patient:{
          ssn: "ssn here"
         }
        }

        return request
      end

      def match_by_name_city_state
        # FindPatientService

        response  = FINDPATIENT_CLIENT.call(:match_by_name_city_state_m_s, message: match_by_name_city_state_request)

        return response.body
      end # def match_by_name_city_state

      def match_by_name_city_state_request
        login_via_request = VIA_API.login_via_request
        login_via_response = FINDPATIENT_CLIENT.call(:login_v_i_a, message: login_via_request).body
        duz           = login_via_response[:login_via_response][:user_to][:duz]
        user_name     = login_via_response[:login_via_response][:user_to][:name]
        site_id       = login_via_response[:login_via_response][:user_to][:site_id]

        request = {}
        request[:queryBean]= {
         provider:{
          userId: duz,
          name: user_name,
          loginSiteCode: site_id
         },
         name: "LASTNAME,FIRSTNAME format search query",
         requestingApp: "requestingApp here",
         target: "Valid City Name",
         criteria: "2-character US State abbreviation or valid US territory abbreviation"
        }

        return request
      end
    end
  end
end