module VIA_API
  class AppointmentType
    class << self

      def get_appointment_types
        # SchedulingService

        response  = SCHEDULING_CLIENT.call(:get_appointment_types, message: appointment_type_request)

        return response.body
      end # def get_appointments
      alias_method :get, :get_appointment_types

      def appointment_type_request
        login_via_request = VIA_API.login_via_request
        login_via_response = SCHEDULING_CLIENT.call(:login_v_i_a, message: login_via_request).body

        duz           = login_via_response[:login_via_response][:user_to][:duz]
        user_name     = login_via_response[:login_via_response][:user_to][:name]
        site_id       = login_via_response[:login_via_response][:user_to][:site_id]

        request = {}
        request[:queryBean]= {
         provider:{
          userId: duz,
          name: user_name,
          loginSiteCode: site_id
         },
         requestingApp: "requestingApp here"
        }

        return request
      end
    end
  end
end