module VIA_API
  class Appointment
    class << self

      def get_appointment
        # EmrService

        response  = EMR_CLIENT.call(:get_appointments, message: get_appointment_request)

        # Savon's inbuilt response.body or response.to_hash
        # are unable to parse the response accurately

        xml = response.to_xml

        # Parsing the XML using Nokogiri
        doc = Nokogiri::XML(xml)

        # Appointments as Nokogiri elements
        appts = doc.xpath "//appointmentTO"

        appointments = []

        # Building an array of appointment hashes
        appts.each do |appt|
          appointments << VIA_API.x2h(appt)
        end

        return appointments
      end # def get_appointment
      alias_method :get, :get_appointment

      def get_appointment_request

        login_via_request = VIA_API.login_via_request
        login_via_response = EMR_CLIENT.call(:login_v_i_a, message: login_via_request).body

        duz           = login_via_response[:login_via_response][:user_to][:duz]
        user_name     = login_via_response[:login_via_response][:user_to][:name]
        site_id       = login_via_response[:login_via_response][:user_to][:site_id]

        request = {}
        request[:queryBean]= {
         provider:{
          userId: duz,
          name: user_name,
          loginSiteCode: site_id
         },
         patient:{
          localPid: "localPid",
          localSiteId: "localSiteId",
          mpiPid: "mpiPid"
         },
         requestingApp: "requestingApp here"
        }

        return request
      end # def appointment_request_body

      def make_appointment
        # SchedulingService

        response  = SCHEDULING_CLIENT.call(:make_appointment, message: make_appointment_request)

        return response.body
      end # def make_appointment
      alias_method :make, :make_appointment

      def make_appointment_request
        login_via_request = VIA_API.login_via_request
        login_via_response = SCHEDULING_CLIENT.call(:login_v_i_a, message: login_via_request).body

        duz           = login_via_response[:login_via_response][:user_to][:duz]
        user_name     = login_via_response[:login_via_response][:user_to][:name]
        site_id       = login_via_response[:login_via_response][:user_to][:site_id]

        request = {}

        request[:queryBean]= {
         provider:{
          userId: duz,
          name: user_name,
          loginSiteCode: site_id
         },
         patient:{
          localPid: "localPid",
          localSiteId: "localSiteId",
          mpiPid: "mpiPid"
         },
         requestingApp: "requestingApp here",
         consumingAppToken: "consumingAppToken here",
         consumingAppPassword: "consumingAppPassword here"
        }

        request[:appointment] = {
         labDateTime: "labDateTime here",
         xrayDateTime: "xrayDateTime here",
         ekgDateTime: "ekgDateTime here",
         purpose: "purpose here",
         clinicId: "clinicId here",
         appointmentTimestamp: "appointmentTimestamp here",
         purposeSubcategory: "purposeSubcategory here",
         appointmentLength: "appointmentLength here",
         appointmentType: "appointmentType here",
         bookNotes: "bookNotes here",
         consultIen: "consultIen here",
         lvl: "lvl here",
         desiredDateTime: "desiredDateTime here"
        }

        return request
      end
    end
  end
end