module VIA_API

  # EMR SERVICE
  VIA_EMR_WSDL         = ENV['VIA_API_WSDL']
  VIA_EMR_ENDPOINT_URL = ENV['VIA_API_ENDPOINT_URL']
  VIA_EMR_NAMESPACE    = ENV['VIA_API_NAMESPACE']

  # SCHEDULING SERVICE
  VIA_SCHEDULING_WSDL         = ENV['VIA_API_WSDL']
  VIA_SCHEDULING_ENDPOINT_URL = ENV['VIA_API_ENDPOINT_URL']
  VIA_SCHEDULING_NAMESPACE    = ENV['VIA_API_NAMESPACE']

  # FINDPATIENT SERVICE
  VIA_FINDPATIENT_WSDL         = ENV['VIA_API_WSDL']
  VIA_FINDPATIENT_ENDPOINT_URL = ENV['VIA_API_ENDPOINT_URL']
  VIA_FINDPATIENT_NAMESPACE    = ENV['VIA_API_NAMESPACE']

  EMR_CLIENT = Savon.client(
   # wsdl: VIA_EMR_WSDL,
   endpoint: VIA_EMR_ENDPOINT_URL,
   namespace: VIA_EMR_NAMESPACE,
   log: true,
   logger: Rails.logger,
   pretty_print_xml: true
  )

  SCHEDULING_CLIENT = Savon.client(
   # wsdl: VIA_SCHEDULING_WSDL,
   endpoint: VIA_SCHEDULING_ENDPOINT_URL,
   namespace: VIA_SCHEDULING_NAMESPACE,
   log: true,
   logger: Rails.logger,
   pretty_print_xml: true
  )

  FINDPATIENT_CLIENT = Savon.client(
   # wsdl: VIA_FINDPATIENT_WSDL,
   endpoint: VIA_FINDPATIENT_ENDPOINT_URL,
   namespace: VIA_FINDPATIENT_NAMESPACE,
   log: true,
   logger: Rails.logger,
   pretty_print_xml: true
  )

  class << self

    def login_via_request
      request = {}
      request[:siteCode] = "516"
      request[:accessCode] = "WJJF567"
      request[:verifyCode] = "blahblahblah"
      request[:queryBean]= {
       requestingApp: ENV['VIA_REQ_APP'],
       consumingAppToken: ENV['VIA_CONS_APP_TOKEN'],
       consumingAppPassword: ENV['VIA_CONS_APP_PASS']
      }

      return request
    end

    # To convert a noko element to hash while parsing a xml
    def x2h(noko_element)
      Hash.from_xml(noko_element.to_s)
    end

  end # class << self
end # module VIA_API
