class SpineEvaluationPresenter < EvaluationPresenter
  
  EXAM_TO_XML_FIELD_MAP = [
    {"initialRomFlexion" => "flexionActual"},
    {"repetitiveRomFlexion" => "flexionDeluca"},
    {"repeatedUseRomFlexion" => "flexionMitchell"},
    {"flareupRomFlexion" => "flexionFlareUp"},
    {"initialRomExtension" => "extensionActual"},
    {"repetitiveRomExtension" => "extensionDeluca"},
    {"repeatedUseRomExtension" => "extensionMitchell"},
    {"flareupRomExtension" => "extensionFlareUp"},
    {"initialRomRightLateralFlexion" => "rightLateralFlexionActual"},
    {"repetitiveRomRightLateralFlexion" => "rightLateralFlexionDeluca"},
    {"repeatedUseRomRightLateralFlexion" => "rightLateralMitchell"},
    {"flareupRomRightLateralFlexion" => "rightLateralFlareUp"},    
    {"initialRomLeftLateralFlexion" => "leftLateralFlexionActual"},
    {"repetitiveRomLeftLateralFlexion" => "leftLateralFlexionDeluca"},
    {"repeatedUseRomLeftLateralFlexion" => "leftLateralMitchell"},
    {"flareupRomLeftLateralFlexion" => "leftLateralFlareUp"},
    {"initialRomRightRotation" => "rightRotationActual"},
    {"repetitiveRomRightRotation" => "rightRotationDeluca"},
    {"repeatedUseRomRightRotation" => "rightRotationMitchell"},
    {"flareupRomRightRotation" => "rightRotationFlareUp"},
    {"initialRomLeftRotation" => "leftRotationActual"},
    {"repetitiveRomLeftRotation" => "leftRotationDeluca"},
    {"repeatedUseRomLeftRotation" => "leftRotationMitchell"},
    {"flareupRomLeftRotation" => "leftRotationFlareUp"}    
  ]
  IVDS_SYMPTOMS = ["ivdsFrequency"]
  JOINTS_OBJECTIVE_EVIDENCE = ["disabilityFactorsExcessFatigability", "disabilityFactorsWeakenedMovement", "disabilityFactorsIncoordination",
   "disabilityFactorsLackOfEndurance", "objectiveFlareups", "romPainful"]
  JOINTS_OTHER_DIAGNOSES = ["objectiveFlareups"]
  EXCLUDED_FIELDS = IVDS_SYMPTOMS + JOINTS_OBJECTIVE_EVIDENCE + JOINTS_OTHER_DIAGNOSES + ["hasArthritisType"]
  
  def modify_document
    form = FML::Form.from_json(evaluation.doc.to_json)
    
    JOINTS_OBJECTIVE_EVIDENCE.each do |joint_evidence|
      if form.fields[joint_evidence].value
        add_presentable_symptom(form.fields[joint_evidence].attrs["attrs"]["ratingCalculator"], "jf", "jointsObjectiveEvidence", "spf:spineFacts", "jointsObjectiveEvidence")
      end
    end

    puts (form.fields["contributingFactorsOfDisability"].value == false)
    if form.fields["contributingFactorsOfDisability"].value == false
      tag = Nokogiri::XML::Node.new("jf:jointsObjectiveEvidence", document)
      valueTag = Nokogiri::XML::Node.new("jf:value", document)
      valueTag.content = "None of the above"
      tag << valueTag
      evaluation_root.xpath("spf:spineFacts").first << tag 
    end   
 
    if form.fields['hasArthritis'].value == true
      add_presentable_symptom(rating_calculator_options_match(form.fields['hasArthritisType']), 'jf', 'jointsOtherDiagnoses', 'spf:spineFacts', 'jointsOtherDiagnoses')
    end
    
    add_presentable_symptom(spine_diagnoses(form.fields), "spf", "spineDiagnoses", "spf:spineFacts", "spineDiagnoses")
    
    add_presentable_symptoms(namespace: 'spf', basename: 'spine', excluded_fields: EXCLUDED_FIELDS)
    
    if form.fields['hasIVDS'].value == true
      add_presentable_symptom(rating_calculator_options_match(form.fields['ivdsFrequency']), "spf", "spineIVDS", "spf:spineFacts", "spineIVDS")
    end
    
    EXAM_TO_XML_FIELD_MAP.each do |fact|
      exam_field_name = fact.keys.first
      xml_field_name = fact[exam_field_name]
      if form.fields[exam_field_name] && form.fields[exam_field_name].to_h.has_key?(:value)
        fact_node = Nokogiri::XML::Node.new("spf:#{xml_field_name}", document)
        fact_node.content = form.fields[exam_field_name].value
        evaluation_root.xpath("spf:spineFacts").first << fact_node
      end
    end

    add_parent_evaluations(evaluation, "//spf:spineFacts")
  end
  
  def spine_diagnoses(fields)
    rating_calculator_options_match(fields[@spine_diagnosis_field_name])
  end
end
