class ScarHeadFaceNeckEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: "Scar - Head, Face, Neck", base_document: 'scar-head-face-neck.xml'

  XML_FIELDS = ["hyperPigmented", "hypoPigmented", "elevatedOnPalpation",
    "depressedonPalpation", "induratedAndInflexible", "softTissueMissing",
    "adherentToTissue", "circular", "painful", "unstable", "scarLength",
    "scarWidth", "estimatedArea", "scarType"]

  def modify_document
    #add_presentable_symptoms(namespace: 'hfnsf', basename: 'HeadFaceNeckScar')

    form = FML::Form.from_json(@evaluation.doc.to_json)
    XML_FIELDS.each do |field_name|
      if form.fields.key?(field_name) && form.fields[field_name].to_h.key?(:value)
        # We have to add an `hfnsf:unit` element immediately before scarType
        # with value "cm"
        add_fact_node("hfnsf:unit", "cm", "hfnsf:headFaceNeckScarFacts") if field_name == "scarType"

        add_fact_node("hfnsf:#{field_name}",
                      form.fields[field_name].value,
                      "hfnsf:headFaceNeckScarFacts")
      end
    end

    add_parent_evaluations(evaluation, "//hfnsf:headFaceNeckScarFacts")
  end
end
