class MusculoskeletalShoulderEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Musculoskeletal-Shoulder', base_document: 'shoulder.xml'

  def modify_document
    evaluation_root.xpath("shf:shoulderFacts/shf:shoulderDiagnoses/shf:value").first.content = evaluation.evaluation_spec.title
    add_presentable_symptoms(namespace: 'shf', basename: 'shoulder', after: 'shoulderDiagnoses')

    fields = FML::Form.from_json(evaluation.doc.to_json).fields

    # this is a boolean field in xsd, from a dropdown in the form
    setfield('//shf:ambidextrous', to: ( fields['dominantHand'].value == 'Ambidextrous') )

    setfield_required('//shf:degreeOfAnkylosis', fields['hasAnkylosisDegrees'].value)

    setfield_required('//shf:forwardFlexionActualDegrees', fields['initialRomFlexion'].value)
    setfield_required('//shf:forwardFlexionDeLucaDegrees', fields['repetitiveRomFlexion'].value)

    setfield_required('//shf:abductionActualDegrees', fields['initialRomAbduction'].value)
    setfield_required('//shf:abductionDelucaDegrees', fields['repetitiveRomAbduction'].value)
    setfield_required('//shf:internalRotationActualDegrees', fields['initialRomInternalRotation'].value)
    setfield_required('//shf:internalRotationDelucaDegrees', fields['repetitiveRomInternalRotation'].value)
    setfield_required('//shf:externalRotationActualDegrees', fields['initialRomExternalRotation'].value)
    setfield_required('//shf:externalRotationDelucaDegrees', fields['repetitiveRomExternalRotation'].value)

    setfield('//shf:clavicleScapulaAffectROM', to: ( fields['clavicleScapulaStatus'].value != 'None' ) )
    setfield('//shf:humerusAffectsROM', to: ( fields['humerusStatus'].value != 'None' ) )


    setfield('//shf:ankylosisofScapulohumeralArticulation', to: ( fields['hasAnkylosis'].value ) )

    add_parent_evaluations(evaluation, "//shf:shoulderFacts")
  end
end
