PresenterStruct ||= Struct.new(:presenter, :base_document)

class EvaluationPresenter
  @@subclasses ||= {}
  attr_accessor :evaluation, :document, :base_document, :ns
#cs  attr_accessor :evaluation, :document, :base_document, :ns, :the_current_evaluation_form   #cs 2016-09-14

  def self.presenter_for(bodySystem:, base_document:)
#binding.pry #cs
    @@subclasses[bodySystem] = PresenterStruct.new(self, base_document)
  end

  # render an evaluation.
  #
  # evaluation is the Evaluation instance to render
  # render_pdf is a boolean representing whether to render the pdf or not. You
  #            want this to be true except in testing
  def self.render(evaluation, render_pdf=true)
    body_system = evaluation.evaluation_spec.body_system
    if Rails.env.development? || Rails.env.test?
      # for development autoloading
#binding.pry #cs
#cs      require 'fullbody_evaluation_presenter.rb'  #CS TEMPORARY!!!!
#binding.pry #cs
      eval(body_system.parameterize.underscore.classify + "EvaluationPresenter")
    end

#binding.pry #cs
    klass = @@subclasses[body_system]
    raise "No renderer found for #{body_system} body system" unless klass
    instance = klass.presenter.new(evaluation, @@subclasses[body_system])
    return instance.format_document(render_pdf)
  end

  def initialize(evaluation, struct)
#binding.pry #cs
    @evaluation = evaluation
    @base_document = struct.base_document
    @the_current_evaluation_form= FML::Form.from_json(evaluation.doc.to_json)   #cs 2016-09-14
  end

  def format_document(render_pdf)
#    @the_current_evaluation_form= FML::Form.from_json(evaluation.doc.to_json)   #cs 2016-09-14
    load_xml(base_document)
    set_general_information(render_pdf)
    modify_document
#csbinding.pry #cs
    return document.to_xml
  end

  # Subclasses should override this to modify the document
  def modify_document
  end

  def add_presentable_symptoms(namespace:, basename:, root: nil, symptoms_element: nil, after: nil, presentation_subset: /.*/, excluded_fields: [])
    root ||= "#{namespace}:#{basename}Facts"
    after_node = evaluation_root.xpath("#{namespace}:#{basename}Facts/#{namespace}:#{after}").first if after

    presentable_symptoms = presentable_fields(presentation_subset, excluded_fields).each do |field|
      add_presentable_symptom(field[:calculator_value], namespace, basename, root, symptoms_element, after_node)
    end

    # if there are no presentable symptoms, append an empty #{basename}Symptoms node
    if presentable_symptoms.size == 0
      symptoms_name = symptoms_element.nil? ? basename + 'Symptoms' : symptoms_element
      evaluation_root.xpath(root).first << make_symptoms_node(namespace, symptoms_name, nil, document)
    end

    presentable_symptoms
  end

  def add_presentable_symptom(symptom, namespace, basename, root, symptoms_element = nil, after_node = nil)
    symptoms_name = symptoms_element.nil? ? basename + 'Symptoms' : symptoms_element
    symptoms_node = make_symptoms_node(namespace, symptoms_name, symptom, document)
    if after_node
      after_node.add_next_sibling(symptoms_node)
    else
      evaluation_root.xpath(root, document.namespaces).first << symptoms_node
    end
  end

  def add_fact_node(element_name, value, parent_element_name)
    fact_node = Nokogiri::XML::Node.new(element_name, document)
    fact_node.content = value
    evaluation_root.xpath(parent_element_name).first << fact_node
  end

  def setfield(name, to:)
    field = evaluation_root.xpath(name).first
    field.content = to
  end

  # set the field if the value is true, else remove the field
  def setfield_required(name, value)
    if value
      field = evaluation_root.xpath(name).first
      field.content = value
    else
      field = evaluation_root.xpath(name).first
      field.unlink
    end
  end

  def add_parent_evaluations(evaluation, facts_node_xpath)
    parent_evaluation = evaluation.primary_evaluation
    dependent_diagnosis_title = evaluation.evaluation_spec.title
    while parent_evaluation
      parent_document = Nokogiri::XML(parent_evaluation.to_xml)
      dependent_diagnosis_node = Nokogiri::XML::Node.new("bsf:dependentDiagnosis", parent_document)
      dependent_diagnosis_node.content = dependent_diagnosis_title
      parent_document_facts = parent_document.xpath(facts_node_xpath, parent_document.namespaces).first

      if parent_document_facts.nil?
        raise "Unable to find node at #{facts_node_xpath}"
      end

      # if the facts node has any bodySystemFacts nodes already in place, the
      # dependentDiagnosis node must go after those nodes but before the
      # diagnosis node. So, if we find any elements namespaced to bsf within
      # the facts node, insert dependent_diagnosis_node after them. Else,
      # insert it as the first child of the facts node
      body_system_facts = parent_document_facts.xpath("*[namespace-uri()='#{parent_document_facts.namespaces["xmlns:bsf"]}']")
      if body_system_facts.empty?
        parent_document_facts.prepend_child dependent_diagnosis_node
      else
        body_system_facts.last.add_next_sibling dependent_diagnosis_node
      end

      facts_node = parent_document.root.xpath(facts_node_xpath, parent_document.namespaces)[0]

      last_facts_node = document.xpath(facts_node_xpath, parent_document.namespaces)[-1]
      last_facts_node.add_next_sibling facts_node.to_s

      dependent_diagnosis_title = parent_evaluation.evaluation_spec.title
      parent_evaluation = parent_evaluation.primary_evaluation
    end
  end
  

  private

  def make_symptoms_node(namespace, symptoms_name, symptom=nil, document)
    symptoms_node = Nokogiri::XML::Node.new("#{namespace}:#{symptoms_name}", document)
    value_node = Nokogiri::XML::Node.new("#{namespace}:value", document)
    value_node.content = symptom
    symptoms_node << value_node
  end

  def load_xml(base_document_name)
    path = File.join(Rails.root.to_s, 'app', 'xml', base_document_name)
    @document = Nokogiri::XML(File.open(path))
  end

  def evaluation_root
    document.root.xpath("cld:EvaluationData", document.namespaces)
  end

  def presentable_fields(matching = /.*/, excluded_fields = [])
    form = FML::Form.from_json(evaluation.doc.to_json)
    fields = evaluation.evaluation_spec.ratings_calculator_fields.select do |h|
      h[:name] =~ matching && !excluded_fields.include?(h[:name])
    end
    ratings_calculator_fields = fields.collect do |ratings_calculator_field|
      form_field = form.fields[ratings_calculator_field[:name]]
      if form_field && (form_field.value == true || form_field.value == ratings_calculator_field[:calculator_value])
        ratings_calculator_field
      end
    end.compact
  end

  def set_general_information(render_pdf)
    receipt_date = Time.now.utc.iso8601
    common_data_node = document.root.xpath("cld:CommonData", document.namespaces)
    common_data_node.xpath("nc:Document/nc:DocumentCreationDate/nc:DateTime", document.namespaces).first.content = receipt_date
    common_data_node.xpath("nc:Document/nc:DocumentIdentification/nc:IdentificationID").first.content = evaluation.guid
    common_data_node.xpath("nc:Document/nc:DocumentTitleText").first.content = "VA Disability Assessment #{evaluation.evaluation_spec.evaluation_builder_title}"
    common_data_node.xpath("vler:ExamDetail/vler:ExamId", document.namespaces).first.content = evaluation.guid
    common_data_node.xpath("vler:ExamDetail/vler:StatusDate/nc:DateTime", document.namespaces).first.content = receipt_date

    examiner_name_node = common_data_node.xpath("nc:Person/nc:PersonName").first
    examiner_name_node.xpath("nc:PersonGivenName").first.content = evaluation.user.first_name
    examiner_name_node.xpath("nc:PersonSurName").first.content = evaluation.user.last_name

    veteran_node = common_data_node.xpath("nc:Person")[1]
    veteran_node.xpath("nc:PersonBirthDate/nc:Date").first.content = evaluation.claim.date_of_birth.to_s
    veteran_node.xpath("nc:PersonName/nc:PersonGivenName").first.content = evaluation.claim.first_name
    veteran_node.xpath("nc:PersonName/nc:PersonSurName").first.content = evaluation.claim.last_name
    veteran_node.xpath("nc:PersonSSNIdentification/nc:IdentificationID").first.content = evaluation.claim.patient_ssn

    facility_node = common_data_node.xpath("nc:Facility").first
    facility_node.xpath("nc:FacilityIdentification/nc:IdentificationID").first.content = evaluation.claim.facility_number
    facility_node.xpath("nc:FacilityIdentification/nc:IdentificationJurisdictionText").first.content = evaluation.claim.facility_name
    facility_node.xpath("nc:FacilityName").first.content = evaluation.claim.facility_name

    if render_pdf
      document.root.xpath("cld:Attachments", document.namespaces).first << create_attachment(evaluation.to_pdf, evaluation.temp_pdf_path.basename.to_s, "application/pdf")
    end
    document.root.xpath("cld:Attachments", document.namespaces).first << create_attachment(evaluation.to_txt, "cui-#{evaluation.guid}.txt", "text/plain")
  end

  def create_attachment(content, location, format)
    binary_base64_object_node = Nokogiri::XML::Node.new("nc:BinaryBase64Object", document)
    binary_base64_object_node.content = Base64.encode64(content)
    binary_location_uri_node = Nokogiri::XML::Node.new("nc:BinaryLocationURI", document)
    binary_location_uri_node.content = location
    binary_format_node = Nokogiri::XML::Node.new("nc:BinaryFormatStandardName", document)
    binary_format_node.content = format
    attachment_node = Nokogiri::XML::Node.new("nc:Attachment", document)
    attachment_node << binary_base64_object_node
    attachment_node << binary_format_node
    attachment_node << binary_location_uri_node
    attachment_node
  end

  def rating_calculator_options_match(field)
    field.options.each do |option|
      if option['name'] == field.value
        return option['ratingCalculator']
      end
    end
    return nil
  end
  
  
#cs new utility methods 2016-09-14 vvvvvv


  def the_evaluation_data_node_from_the_document_being_presented
    document.root.xpath("cld:EvaluationData", document.namespaces).first
  end

  def a_new_xml_node(the_namespace, the_node_name, the_document=document)
    the_new_node = Nokogiri::XML::Node.new("#{the_namespace}:#{the_node_name}", the_document)
#    value_node.content = symptom
#    symptoms_node << value_node
#binding.pry #cs
    return the_new_node
  end

  def a_new_body_facts_node(the_node_name, the_document=document)
    return a_new_xml_node('cld', the_node_name, the_document)
  end
  
  def add_a_child_at_the_beginning_of_a_node(the_parent_node, the_node_to_add)
    the_parent_node.prepend_child(the_node_to_add)
  end

  def add_a_child_at_the_beginning_of_the_evaluation_data_node(the_node_to_add)
#    document.root.xpath("cld:EvaluationData", document.namespaces).add_child(the_node_to_add)
#binding.pry #cs
    add_a_child_at_the_beginning_of_a_node(the_evaluation_data_node_from_the_document_being_presented, the_node_to_add)
#binding.pry #cs
  end    

  def add_the_claim_id_to_the_claim_id_node
    the_claim_id_node = document.root.xpath("cld:ClaimID", document.namespaces).first
    the_claim_id = evaluation.claim.vbms_claim_id
    if the_claim_id == nil
      the_claim_id = "UNDEFINED"
    end
#binding.pry #cs
    the_claim_id_value_element = Nokogiri::XML::Text.new(the_claim_id, document)
#binding.pry #cs
    the_claim_id_node << the_claim_id_value_element
#binding.pry #cs
  end

#cs new utility methods 2016-09-14 ^^^^^^

  
end
