class EndocrineEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Endocrine', base_document: 'endocrine.xml'
  
  def modify_document
    evaluation_root.xpath("ef:endocrineFacts/ef:endocrineDiagnoses/ef:value").first.content = evaluation.evaluation_spec.title

    form = FML::Form.from_json(evaluation.doc.to_json)
    if form.fields["disfigurementOfHeadAndOrNeck"] != nil && form.fields["disfigurementOfHeadAndOrNeck"].value == false
      add_presentable_symptom("Without disfigurement of the head or neck", 'ef', 'endocrine', "ef:endocrineFacts")
    end

    presentable_symptoms = add_presentable_symptoms(namespace: 'ef', basename: 'endocrine', excluded_fields: ["tachycardia", "tachycardiaFrequency", "disfigurementOfHeadAndOrNeck"])

    evaluationTitle = evaluation.evaluation_spec.title
    if evaluationTitle == "Thyroid gland, toxic adenoma of" || evaluationTitle == "Hyperthyroidism"
      tachycardiaSelected = getValue(form, "tachycardia")
      tachycardiaFrequencySelected = getValue(form, "tachycardiaFrequency")
  
      if tachycardiaSelected == true
        if tachycardiaFrequencySelected == true
          addTag("ef", "endocrineSymptoms", getRatingCalculatorValue(form, "tachycardiaFrequency"), true)
        else
          addTag("ef", "endocrineSymptoms", getRatingCalculatorValue(form, "tachycardia"), true)
        end
      end
    end
    
    no_complications_node = Nokogiri::XML::Node.new("ef:noComplications", document)
    no_complications_node.content = presentable_symptoms.size > 0 ? false : true
    evaluation_root.xpath("ef:endocrineFacts").first << no_complications_node

    add_parent_evaluations(evaluation, "//ef:endocrineFacts")
  end

  private

  def addTag(namespace, tagName, tagValue, addValueTag)
    evaluation_root.xpath("ef:endocrineFacts").first << getTag(namespace, tagName, tagValue, addValueTag)
  end
  
  def getTag(namespace, tagName, tagValue, addValueTag)
    tag = Nokogiri::XML::Node.new(namespace+":"+tagName, document)

    if addValueTag
      valueTag = Nokogiri::XML::Node.new(namespace+":value", document)
      valueTag.content = tagValue
      tag << valueTag
    else
      tag.content = tagValue
    end
    tag
  end
  
  def getValue(form, fieldName)
    form.fields[fieldName].value
  end

  def getRatingCalculatorValue(form, fieldName)
    fields = evaluation.evaluation_spec.ratings_calculator_fields.select do |h|
    if h[:name] == fieldName
        h
      end
    end
    filteredFieldValue = fields.collect do |ratings_calculator_field|
      form_field = form.fields[ratings_calculator_field[:name]]

      if form_field && (form_field.value == true || form_field.value == ratings_calculator_field[:calculator_value])
        ratings_calculator_field[:calculator_value]
      end
    end.compact
    filteredFieldValue[0]
  end
end
