class EarDiseaseAndOtherSenseOrganEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Ear Disease and other Sense Organs', base_document: 'ear.xml'

  AUDIOMETRIC_FIELDS = ["leftEar500", "leftEar1000", "leftEar2000", "leftEar3000", "leftEar4000", 
    "rightEar500", "rightEar1000", "rightEar2000", "rightEar3000", "rightEar4000"]
  SPEECH_DETERMINATION_FIELD_MAP = [
    {"speechDiscriminationScoreLeft" => "leftEarSpeechDiscrimination"},
    {"speechDiscriminationScoreRight" => "rightEarSpeechDiscrimination"}  
  ]
  
  def modify_document
    form = FML::Form.from_json(evaluation.doc.to_json)
    if evaluation.doc['form']['title'] == 'Hearing Loss'
      evaluation_root.xpath("aaf:auditoryAcuityFacts").remove
      hearing_loss_node = Nokogiri::XML::Node.new("tns:hearingLoss", document)
      evaluation_root.first << hearing_loss_node

      hearing_loss_node = evaluation_root.xpath("tns:hearingLoss")

      AUDIOMETRIC_FIELDS.each do |hearing_loss_field|
        add_fact_node("tns:#{hearing_loss_field}", form.fields[hearing_loss_field].value, "tns:hearingLoss")
      end
      add_fact_node("tns:leftEarScoresAvailable", "Not Available", "tns:hearingLoss")
      add_fact_node("tns:rightEarScoresAvailable", "Not Available", "tns:hearingLoss")
      SPEECH_DETERMINATION_FIELD_MAP.each do |hearing_loss_field|
        key = hearing_loss_field.keys.first
        value = hearing_loss_field[key]
        add_fact_node("tns:#{value}", form.fields[key].value, "tns:hearingLoss") if form.fields[key]
      end
    else
      evaluation_root.xpath("aaf:auditoryAcuityFacts/aaf:auditoryAcuityDiagnoses/aaf:value").first.content = evaluation.evaluation_spec.title
      add_presentable_symptoms(namespace: 'aaf', basename: 'auditoryAcuity')
      inferred_claim_of_hearing_loss_node = Nokogiri::XML::Node.new("aaf:inferredClaimOfHearingLoss", document)
      evaluation_root.xpath("aaf:auditoryAcuityFacts").first << inferred_claim_of_hearing_loss_node
    end

    add_parent_evaluations(evaluation, "//aaf:auditoryAcuityFacts")
  end
end
