class DentalAndOralEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Dental and Oral', base_document: 'dental.xml'

  EXAM_TO_XML_FIELD_MAP = {
    #missingTeeths
    #actualInterIncisal
    #actualInterIncisalRange
    #delucaInterIncisal
    #delucaInterIncisalRange
    "initialRomLateralExcursion" => "actualLateralExcursion",
    "initialRomInterincisalRange" => "actualLateralExcursionRange",
    "repetitiveRomLateralExcursion" => "delucaLateralExcursion",
    "repetitiveRomInterincisalRange" => "delucaLateralExcursionRange",
    "romPainful" => "painfulMotion"
    #bruxismShown
  }
  
  def modify_document
    evaluation_root.xpath("//dentf:value").first.content = @evaluation.evaluation_spec.title
    add_presentable_symptoms(namespace: 'dentf', basename: 'dental')
    form = FML::Form.from_json(@evaluation.doc.to_json)
    EXAM_TO_XML_FIELD_MAP.each do |exam_field_name, xml_field_name|
      if form.fields[exam_field_name] && form.fields[exam_field_name].to_h.has_key?(:value)
        fact_node = Nokogiri::XML::Node.new("dentf:#{xml_field_name}", @document)
        fact_node.content = form.fields[exam_field_name].value
        evaluation_root.xpath("dentf:dentalFacts").first << fact_node
      end
    end

    add_parent_evaluations(evaluation, "//dentf:dentalFacts")
  end
end
