# == Schema Information
#
# Table name: veterans
#
#  id                          :integer          not null, primary key
#  ssn                         :string(10)       not null
#  first_name                  :string
#  middle_name                 :string
#  last_name                   :string
#  other_health_insurance_name :string
#  content                     :json
#  created_at                  :datetime         not null
#  updated_at                  :datetime         not null
#  other_health_insurance_id   :integer
#

class Veteran < ActiveRecord::Base
  belongs_to :other_health_insurance

  has_many :consultations
  has_many :referrals, through: :consultations

  autowire_content_fields :gender, :date_of_birth, :address, :city, :state, :zip

  def address_attrs
    {:address=>address, :city=>city, :state=>state, :zip=>zip}
  end

  def full_name
    [first_name, middle_name, last_name].join(' ')
  end
  alias_method :patient_name, :full_name


  def formatted_ssn
    "#{ssn.slice(0,3)}-#{ssn.slice(3,2)}-#{ssn.slice(5,4)}"
  end


  def has_other_health_insurance?
    case other_health_insurance.title.strip.downcase
      when 'yes'  # SMELL: tight coupling to the contents of the static text table
        true
      when 'no'
        false
      else
        raise "Unknown"
    end
  end


  #############################################################
  class << self


    def filtered_veterans(params)
      if params[:from_date].present? && params[:to_date].present?
        date_filter = {created_at: (Date.strptime params[:from_date], "%m/%d/%Y")..(Date.strptime params[:to_date], "%m/%d/%Y") +1}
      else
        date_filter = {created_at: ''}
      end
      veteran_filter_params = {ssn: params[:ssn].gsub(/\D/,''), first_name: params[:first_name], last_name: params[:last_name]}.merge(date_filter).delete_if{|k,v| v.to_s.strip == ''}
      self.where(veteran_filter_params)
    end

  end # class << self

end # class Veteran < ActiveRecord::Base
