# == Schema Information
#
# Table name: user_preferences
#
#  id                  :integer          not null, primary key
#  consultation_filter :json
#  referral_filter     :json
#  user_id             :integer
#  created_at          :datetime         not null
#  updated_at          :datetime         not null
#  time_zone           :string
#

class UserPreference < ActiveRecord::Base
  belongs_to :user

  def save_filter(controller, filter_params)
    if [:referral, :consultation].include? controller
      filter_assign_method = "#{controller}_filter="
      if filter_params.present?
        send(filter_assign_method, filter_params)
        return save
      else
        return clear_filter(controller)
      end
    else
      return false
    end
  end

  # Clear either all user preferences or a single preference type.
  # Parameter accepted values:
  # :all - clear all values
  # :consultation - clear consultation filter only
  # :referral - clear referral filter only
  def clear_filter(controller = :all)
    if [:all, :consultation].include? controller
      consultation_filter.clear
    end
    if [:all, :referral].include? controller
      referral_filter.clear
    end
    save
  end


end
