# == Schema Information
#
# Table name: question_modifiers
#
#  id          :integer          not null, primary key
#  name        :string
#  label       :string
#  mod_type    :string
#  list_values :string           default([]), is an Array
#  html        :text
#  created_at  :datetime         not null
#  updated_at  :datetime         not null
#

class QuestionModifier < ActiveRecord::Base
  include ContentManagerHelper
  has_many :qm_assignments, dependent: :delete_all
  has_many :general_questions, :through => :qm_assignments  

  validates_presence_of :mod_type
  validates_presence_of :name
  validates_uniqueness_of :name
  
  before_save :set_name
  before_update :set_name

  FIELDS_FOR_RESULTSET = {
    0 => 'question_modifiers.name',
    1 => 'question_modifiers.label',
    2 => 'question_modifiers.mod_type',
    3 => 'question_modifiers.list_values'
  }

  class << self
    def filter(params={})
      query = QuestionModifier.all
      unless params[:search][:value].blank?
        query = filter_using_question_modifier(params, query)
      end
      return query
    end

    def filter_using_question_modifier(cp, q)
      q.where('name ilike :search OR label ilike :search OR mod_type ilike :search OR list_values @> ARRAY[:search]::varchar[]', :search => "%#{cp[:search][:value]}%")
    end
  end  


  def build_html(modifier_name,identifier)
#    @bhtml = base_html.clone
    @bhtml = '<br>[HTML for Modifier Type] '
    if self.mod_type == "checkbox"
#      @bhtml = base_without_label_html.clone
      @bhtml.gsub!('[HTML for Modifier Type]', build_checkbox_html())
    elsif self.mod_type == "radio"
      @bhtml.gsub!('[HTML for Modifier Type]', build_radio_html())
    elsif self.mod_type == "single_select"
      @bhtml.gsub!('[HTML for Modifier Type]', build_single_select_html())      
    elsif self.mod_type == "multi_select"
      @bhtml.gsub!('[HTML for Modifier Type]', build_multi_select_html())       
    elsif self.mod_type == "date"
      @bhtml.gsub!('[HTML for Modifier Type]', build_date_html()) 
    elsif self.mod_type == "textarea"
      @bhtml.gsub!('[HTML for Modifier Type]', build_textarea_html())       
    end
    @bhtml.gsub!('[Modifier Name]', modifier_name)
    @bhtml.gsub!('[identifier_base]', identifier)
#    @bhtml.gsub!('[Modifier Label]', self.label)
    return @bhtml
  end
  
  def base_html
    return BASE_HTML
  end

  def base_without_label_html
    return BASE_WITHOUT_LABEL_HTML
  end

  def get_qm_assignments(general_question)
    if general_question.present?
      return self.qm_assignments.where(general_question_id: general_question.id)
    else
      return false
    end
  end

  def update_qma_names
    qm_assignments.includes(:general_question).each { |qma| qma.set_name; qma.save }
  end
  
  
  private 
  
  def build_checkbox_html
    @check_boxes_html = ""
    self.list_values.each do |v|
      chtml = CHECKBOX_HTML.clone
      chtml.gsub!('[option]', v)
      @check_boxes_html += " \n       " + chtml
    end
    return @check_boxes_html.html_safe  
  end

  def build_radio_html
    @radio_buttons_html = ""
    self.list_values.each do |v|
      rhtml = RADIO_HTML.clone
      rhtml.gsub!('[option]', v)
      @radio_buttons_html += " \n       " + rhtml
    end
    return @radio_buttons_html.html_safe  
  end

  def build_single_select_html
    @single_select_html = ""
    
    if self.list_values.count > 0
      @single_select_html = SINGLE_SELECT_HEAD_HTML.clone
      @single_select_html = @single_select_html + '<option selected="selected" value=""> -- select an option -- </option>'
      self.list_values.each do |v|
        shtml = SINGLE_SELECT_OPTION_HTML.clone
        shtml.gsub!('[option]', v)
        shtml.gsub!('<option>', v)
        @single_select_html += " \n               " + shtml
      end
      @single_select_html += " \n         </select>"
    end
    return @single_select_html.html_safe  
  end
  
  def build_multi_select_html
    @multi_select_html = ""
    if self.list_values.count > 0
      @multi_select_html = MULTI_SELECT_HEAD_HTML.clone
      self.list_values.each do |v|
        mhtml = MULTI_SELECT_OPTION_HTML.clone
        mhtml.gsub!('[option]', v)
        mhtml.gsub!('<option>', v)
        @multi_select_html += " \n               " + mhtml
      end
      @multi_select_html += " \n         </select>"
    end
    return @multi_select_html.html_safe  
  end  
  
  def build_date_html
    return DATE_HTML.clone
  end

  def build_textarea_html
    @textarea_html = ""
    thtml = ""
    if self.list_values.count > 0
      self.list_values.each do |v|
        thtml += ", " + v
      end
      thtml.sub!(", ", "")
    end
    @textarea_html = TEXTAREA_HTML.clone
    @textarea_html.gsub!('[Text]', thtml)    
    return @textarea_html.html_safe 
  end


  MODIFIER_TYPES = ["checkbox", "radio", "date", "textarea", "single_select", "multi_select"]

  BASE_HTML = '<div id="question_modifier_container-[Modifier Name]-[identifier_base]" class="container question_modifier" >
	<span id="question_modifier_label-[Modifier Name]-[identifier_base]" class="label question_modifier">
		[Modifier Label]
	</span>
	[HTML for Modifier Type]
  </div>'

  BASE_WITHOUT_LABEL_HTML = '<div id="question_modifier_container-[Modifier Name]-[identifier_base]" class="container question_modifier" >
        [HTML for Modifier Type]
  </div>'
  
#  CHECKBOX_HTML = '<input	id="question_modifier-[Modifier Name]-[identifier_base]-1" type="checkbox" value = "[option]" name="question_modifier-[Modifier Name]-[identifier_base]">
#           <label  for="question_modifier-[Modifier Name]-[identifier_base]-1"> [option] </label>'
#           
#  RADIO_HTML = '<input id="question_modifier-[Modifier Name]-[identifier_base]-1" type="radio" value = "[option]" name="question_modifier-[Modifier Name]-[identifier_base]">
#           <label  for="question_modifier-[Modifier Name]-[identifier_base]-1"> [option] </label>'           

  CHECKBOX_HTML = '<input	id="question_modifier-[Modifier Name]-[identifier_base]" type="checkbox" value = "[option]" name="question_modifier-[Modifier Name]-[identifier_base]">
           <label  for="question_modifier-[Modifier Name]-[identifier_base]"> [option] </label>'
           
  RADIO_HTML = '<input id="question_modifier-[Modifier Name]-[identifier_base]" type="radio" value = "[option]" name="question_modifier-[Modifier Name]-[identifier_base]">
           <label  for="question_modifier-[Modifier Name]-[identifier_base]"> [option] </label>'           
  
#cs  SINGLE_SELECT_HEAD_HTML = '<select id="question_modifier-[Modifier Name]-[identifier_base]" name="question_modifier-[Modifier Name]-[identifier_base]">'
  SINGLE_SELECT_HEAD_HTML   = '<select  id="question_modifier-[Modifier Name]-[identifier_base]-select" name="question_modifier-[Modifier Name]-[identifier_base]-select">'
  SINGLE_SELECT_OPTION_HTML = '<option  value="[option]"><option></option>'
  
  MULTI_SELECT_HEAD_HTML    = '<select  id="question_modifier-[Modifier Name]-[identifier_base]-select" name="question_modifier-[Modifier Name]-[identifier_base]-select[]" multiple="multiple" style="height:100px;">'
  MULTI_SELECT_OPTION_HTML  = '<option  value="[option]"><option></option>' 
  
  DATE_HTML = '<input	id="question_modifier-[Modifier Name]-[identifier_base]" name="question_modifier-[Modifier Name]-[identifier_base]" type="date">'

  TEXTAREA_HTML = '<textarea id="question_modifier-[Modifier Name]-[identifier_base]-textarea" name="question_modifier-[Modifier Name]-[identifier_base]-textarea" rows="4" placeholder="[Modifier Prompt]"> [Text] </textarea>'
  
  
  
  def set_name
    self.name = clean_name(self.name)
  end  

end
