# == Schema Information
#
# Table name: html_repositories
#
#  id         :integer          not null, primary key
#  name       :string
#  html       :text
#  created_at :datetime         not null
#  updated_at :datetime         not null
#

class NokogiriEnabledHtmlRepository < HtmlRepository
    
    def document_fragment # returns the document fragment corresponding to the stored HTML
        the_fragment_to_return = Nokogiri::HTML::DocumentFragment.parse(html)
        return the_fragment_to_return
    end
    
    def stores( the_nokogiri_document_fragment_to_store )
        if( the_nokogiri_document_fragment_to_store.is_a?( Nokogiri::HTML::DocumentFragment) )
            super( the_nokogiri_document_fragment_to_store.to_s )
            save #cs  is this redundant?
        else
            raise StandardError.new("The parameter provided as 'the_nokogiri_document_fragment_to_store' is not an instance of 'Nokogiri::HTML::DocumentFragment'")
        end
    end
    
end
