# == Schema Information
#
# Table name: minor_systems
#
#  id              :integer          not null, primary key
#  name            :string
#  label           :string
#  created_at      :datetime         not null
#  updated_at      :datetime         not null
#  major_system_id :integer
#  position        :integer
#

class MinorSystem < ActiveRecord::Base
  has_many :symptoms
  has_many :diagnoses
  has_many :general_questions
  belongs_to :major_system
  validates_presence_of :name
  validates_presence_of :label

  scope :order_by_position_asc, -> () {all.order("position ASC")}
  scope :order_by_position, -> () { order("position ASC" )}

  def build_html
    @min_html = MINOR_SYSTEM_HTML.clone
    @min_html.gsub!('[Minor System Name]', self.name)
    @min_html.gsub!('[Minor System Label]', self.label)
    s_html = ""
    self.symptoms.order_by_position.each do |s|
      s_html += s.build_html + " \n <br> \n "
    end
    d_html = ""
    self.diagnoses.order_by_position.each do |d|
      d_html += d.build_html + " \n <br> \n "
    end
    gq_html = ""
    self.general_questions.order_by_position.each do |gq|
      gq_html += gq.build_html + " \n <br> \n "
    end
    @min_html.gsub!('[HTML from each Associated Symptom here]', s_html.html_safe)
    @min_html.gsub!('[HTML from each Associated Diagnosis here]', d_html.html_safe)
    @min_html.gsub!('[HTML from each Associated General Question here]', gq_html.html_safe)
    return @min_html
  end

  def base_html
    return MINOR_SYSTEM_HTML
  end





  MINOR_SYSTEM_HTML =
    ' <div id="visibility_container-minor_system-[Minor System Name]" class="container visibility">
        <input 	id="visibility-minor_system-[Minor System Name]" name="visibility-minor_system-[Minor System Name]" type="checkbox" value="checked" visibility_dependents="inner_container-minor_system-[Minor System Name]" onchange="Set_Dependent_Visibility_Based_On(this);">
        <label  for="visibility-minor_system-[Minor System Name]">
		      [Minor System Label]
	      </label>
      </div>
	    <div id="inner_container-minor_system-[Minor System Name]" class="container minor-system inner small-12 columns hidden">
		    <div id="symptom_container-[Minor System Name]" class="container symptom group small-12 columns">

    			[HTML from each Associated Symptom here]

    		</div>

    		<div id="diagnosis_container-[Minor System Name]" class="container diagnosis group small-12 columns">

		    	[HTML from each Associated Diagnosis here]

	     	</div>

        <div id="general_question_container-[Minor System Name]" class="container general_question group small-12 columns">

          [HTML from each Associated General Question here]

        </div>
      </div>'
end
